/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.MediatorPropertyFactory;
import org.apache.synapse.config.xml.OMElementUtils;
import org.apache.synapse.mediators.transform.XSLTMediator;
import org.jaxen.JaxenException;

public class XSLTMediatorFactory
extends AbstractMediatorFactory {
    private static final QName TAG_NAME = new QName("http://ws.apache.org/ns/synapse", "xslt");

    public QName getTagQName() {
        return TAG_NAME;
    }

    public Mediator createMediator(OMElement elem) {
        XSLTMediator transformMediator = new XSLTMediator();
        OMAttribute attXslt = elem.getAttribute(ATT_KEY);
        OMAttribute attSource = elem.getAttribute(ATT_SOURCE);
        OMAttribute attTarget = elem.getAttribute(ATT_TARGET);
        if (attXslt != null) {
            transformMediator.setXsltKey(attXslt.getAttributeValue());
        } else {
            this.handleException("The 'key' attribute is required for the XSLT mediator");
        }
        if (attSource != null) {
            try {
                transformMediator.setSourceXPathString(attSource.getAttributeValue());
                AXIOMXPath xp = new AXIOMXPath(attSource.getAttributeValue());
                OMElementUtils.addNameSpaces(xp, elem, log);
                transformMediator.setSource(xp);
            }
            catch (JaxenException e) {
                this.handleException("Invalid XPath specified for the source attribute : " + attSource.getAttributeValue());
            }
        }
        if (attTarget != null) {
            transformMediator.setTargetPropertyName(attTarget.getAttributeValue());
        }
        this.processTraceState(transformMediator, elem);
        Iterator iter = elem.getChildrenWithName(FEATURE_Q);
        while (iter.hasNext()) {
            OMElement featureElem = (OMElement)iter.next();
            OMAttribute attName = featureElem.getAttribute(ATT_NAME);
            OMAttribute attValue = featureElem.getAttribute(ATT_VALUE);
            if (attName != null && attValue != null) {
                String name = attName.getAttributeValue();
                String value = attValue.getAttributeValue();
                if (name != null && value != null) {
                    if ("true".equals(value.trim())) {
                        transformMediator.addFeature(name.trim(), true);
                        continue;
                    }
                    if ("false".equals(value.trim())) {
                        transformMediator.addFeature(name.trim(), false);
                        continue;
                    }
                    this.handleException("The feature must have value true or false");
                    continue;
                }
                this.handleException("The valid values for both of the name and value are need");
                continue;
            }
            this.handleException("Both of the name and value attribute are required for a feature");
        }
        transformMediator.addAllProperties(MediatorPropertyFactory.getMediatorProperties(elem));
        return transformMediator;
    }
}

