/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Startup;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.ConfigurationFactoryAndSerializerFinder;
import org.apache.synapse.config.xml.StartupFactory;
import org.apache.synapse.config.xml.StartupSerializer;
import org.apache.synapse.startup.quartz.SimpleQuartzFactory;
import sun.misc.Service;

public class StartupFinder {
    private static final Log log = LogFactory.getLog(ConfigurationFactoryAndSerializerFinder.class);
    private static StartupFinder instance = null;
    private static Map factoryMap = new HashMap();
    private static Map serializerMap = new HashMap();
    private static final Class[] builtins = new Class[]{SimpleQuartzFactory.class};

    public static synchronized StartupFinder getInstance() {
        if (instance == null) {
            instance = new StartupFinder();
        }
        return instance;
    }

    public synchronized void reset() {
        factoryMap.clear();
        instance = null;
    }

    private StartupFinder() {
        for (int i = 0; i < builtins.length; ++i) {
            StartupFactory sf;
            Class b = builtins[i];
            try {
                sf = (StartupFactory)b.newInstance();
            }
            catch (Exception e) {
                throw new SynapseException("cannot instantiate " + b.getName(), e);
            }
            factoryMap.put(sf.getTagQName(), b);
            serializerMap.put(sf.getTagQName(), sf.getSerializerClass());
        }
        this.registerExtensions();
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private void registerExtensions() {
        Iterator it = Service.providers(StartupFactory.class);
        while (it.hasNext()) {
            StartupFactory sf = (StartupFactory)it.next();
            QName tag = sf.getTagQName();
            factoryMap.put(tag, sf.getClass());
            serializerMap.put(tag, sf.getSerializerClass());
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Added StartupFactory " + sf.getClass() + " to handle " + tag));
        }
    }

    public Startup getStartup(OMElement element) {
        Class cls;
        QName qName = element.getQName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating the Startup for : " + qName));
        }
        if ((cls = (Class)factoryMap.get(qName)) == null) {
            String msg = "Unknown Startup type referenced by startup element : " + qName;
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        try {
            StartupFactory sf = (StartupFactory)cls.newInstance();
            return sf.createStartup(element);
        }
        catch (InstantiationException e) {
            String msg = "Error initializing configuration factory : " + cls;
            log.error((Object)msg);
            throw new SynapseException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Error initializing configuration factory : " + cls;
            log.error((Object)msg);
            throw new SynapseException(msg, e);
        }
    }

    public OMElement serializeStartup(OMElement parent, Startup startup) {
        Class cls = (Class)serializerMap.get(startup.getTagQName());
        if (cls == null) {
            String msg = "Unknown startup type referenced by startup element : " + startup.getTagQName();
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        try {
            StartupSerializer ss = (StartupSerializer)cls.newInstance();
            return ss.serializeStartup(parent, startup);
        }
        catch (InstantiationException e) {
            String msg = "Error initializing startup serializer: " + cls;
            log.error((Object)msg);
            throw new SynapseException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Error initializing startup ser: " + cls;
            log.error((Object)msg);
            throw new SynapseException(msg, e);
        }
    }

    public Map getFactoryMap() {
        return factoryMap;
    }

    public Map getSerializerMap() {
        return serializerMap;
    }

    public Startup getObjectFromOMNode(OMNode om) {
        if (om instanceof OMElement) {
            return this.getStartup((OMElement)om);
        }
        this.handleException("Invalid configuration XML : " + om);
        return null;
    }
}

