/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractListMediatorFactory;
import org.apache.synapse.mediators.base.SequenceMediator;

public class SequenceMediatorFactory
extends AbstractListMediatorFactory {
    private static final QName SEQUENCE_Q = new QName("http://ws.apache.org/ns/synapse", "sequence");

    public QName getTagQName() {
        return SEQUENCE_Q;
    }

    public SequenceMediator createAnonymousSequence(OMElement elem) {
        String statisticsValue;
        SequenceMediator seqMediator = new SequenceMediator();
        OMAttribute e = elem.getAttribute(ATT_ONERROR);
        if (e != null) {
            seqMediator.setErrorHandler(e.getAttributeValue());
        }
        this.processTraceState(seqMediator, elem);
        SequenceMediatorFactory.addChildren(elem, seqMediator);
        OMAttribute statistics = elem.getAttribute(ATT_STATS);
        if (statistics != null && (statisticsValue = statistics.getAttributeValue()) != null) {
            if ("enable".equals(statisticsValue)) {
                seqMediator.setStatisticsState(1);
            } else if ("disable".equals(statisticsValue)) {
                seqMediator.setStatisticsState(0);
            }
        }
        return seqMediator;
    }

    public Mediator createMediator(OMElement elem) {
        String statisticsValue;
        SequenceMediator seqMediator = new SequenceMediator();
        OMAttribute n = elem.getAttribute(ATT_NAME);
        OMAttribute e = elem.getAttribute(ATT_ONERROR);
        if (n != null) {
            seqMediator.setName(n.getAttributeValue());
            if (e != null) {
                seqMediator.setErrorHandler(e.getAttributeValue());
            }
            this.processTraceState(seqMediator, elem);
            SequenceMediatorFactory.addChildren(elem, seqMediator);
        } else {
            n = elem.getAttribute(ATT_KEY);
            if (n != null) {
                seqMediator.setKey(n.getAttributeValue());
                if (e != null) {
                    String msg = "A sequence mediator with a reference to another sequence can not have 'ErrorHandler'";
                    log.error((Object)msg);
                    throw new SynapseException(msg);
                }
            } else {
                String msg = "A sequence mediator should be a named sequence or a reference to another sequence (i.e. a name attribute or key attribute is required)";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
        }
        OMAttribute statistics = elem.getAttribute(ATT_STATS);
        if (statistics != null && (statisticsValue = statistics.getAttributeValue()) != null) {
            if ("enable".equals(statisticsValue)) {
                seqMediator.setStatisticsState(1);
            } else if ("disable".equals(statisticsValue)) {
                seqMediator.setStatisticsState(0);
            }
        }
        return seqMediator;
    }
}

