/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AggregateMediatorSerializer;
import org.apache.synapse.config.xml.CacheMediatorSerializer;
import org.apache.synapse.config.xml.CalloutMediatorSerializer;
import org.apache.synapse.config.xml.ClassMediatorSerializer;
import org.apache.synapse.config.xml.CloneMediatorSerializer;
import org.apache.synapse.config.xml.DBLookupMediatorSerializer;
import org.apache.synapse.config.xml.DBReportMediatorSerializer;
import org.apache.synapse.config.xml.DropMediatorSerializer;
import org.apache.synapse.config.xml.FaultMediatorSerializer;
import org.apache.synapse.config.xml.FilterMediatorSerializer;
import org.apache.synapse.config.xml.HeaderMediatorSerializer;
import org.apache.synapse.config.xml.InMediatorSerializer;
import org.apache.synapse.config.xml.IterateMediatorSerializer;
import org.apache.synapse.config.xml.LogMediatorSerializer;
import org.apache.synapse.config.xml.MediatorSerializer;
import org.apache.synapse.config.xml.OutMediatorSerializer;
import org.apache.synapse.config.xml.POJOCommandMediatorSerializer;
import org.apache.synapse.config.xml.PropertyMediatorSerializer;
import org.apache.synapse.config.xml.RMSequenceMediatorSerializer;
import org.apache.synapse.config.xml.SendMediatorSerializer;
import org.apache.synapse.config.xml.SequenceMediatorSerializer;
import org.apache.synapse.config.xml.SwitchMediatorSerializer;
import org.apache.synapse.config.xml.SynapseMediatorSerializer;
import org.apache.synapse.config.xml.ValidateMediatorSerializer;
import org.apache.synapse.config.xml.XSLTMediatorSerializer;
import sun.misc.Service;

public class MediatorSerializerFinder {
    private static final Log log = LogFactory.getLog(MediatorSerializerFinder.class);
    private static final Class[] mediatorSerializers = new Class[]{SequenceMediatorSerializer.class, LogMediatorSerializer.class, SendMediatorSerializer.class, FilterMediatorSerializer.class, SynapseMediatorSerializer.class, DropMediatorSerializer.class, HeaderMediatorSerializer.class, FaultMediatorSerializer.class, PropertyMediatorSerializer.class, SwitchMediatorSerializer.class, InMediatorSerializer.class, OutMediatorSerializer.class, RMSequenceMediatorSerializer.class, ClassMediatorSerializer.class, ValidateMediatorSerializer.class, XSLTMediatorSerializer.class, POJOCommandMediatorSerializer.class, CloneMediatorSerializer.class, IterateMediatorSerializer.class, AggregateMediatorSerializer.class, DBLookupMediatorSerializer.class, DBReportMediatorSerializer.class, CacheMediatorSerializer.class, CalloutMediatorSerializer.class};
    private static MediatorSerializerFinder instance = null;
    private static Map serializerMap = new HashMap();

    public static synchronized MediatorSerializerFinder getInstance() {
        if (instance == null) {
            instance = new MediatorSerializerFinder();
        }
        return instance;
    }

    public MediatorSerializer getSerializer(Mediator mediator) {
        return (MediatorSerializer)serializerMap.get(mediator.getClass().getName());
    }

    private MediatorSerializerFinder() {
        serializerMap = new HashMap();
        for (int i = 0; i < mediatorSerializers.length; ++i) {
            Class c = mediatorSerializers[i];
            try {
                MediatorSerializer ser = (MediatorSerializer)c.newInstance();
                serializerMap.put(ser.getMediatorClassName(), ser);
                continue;
            }
            catch (Exception e) {
                throw new SynapseException("Error instantiating " + c.getName(), e);
            }
        }
        this.registerExtensions();
    }

    private void registerExtensions() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering mediator extensions found in the classpath : " + System.getProperty("java.class.path")));
        }
        Iterator it = Service.providers(MediatorSerializer.class);
        while (it.hasNext()) {
            MediatorSerializer ms = (MediatorSerializer)it.next();
            String name = ms.getMediatorClassName();
            try {
                serializerMap.put(name, ms.getClass().newInstance());
            }
            catch (InstantiationException e) {
                MediatorSerializerFinder.handleException("Error instantiating mediator serializer : " + ms);
            }
            catch (IllegalAccessException e) {
                MediatorSerializerFinder.handleException("Error instantiating mediator serializer : " + ms);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Added MediatorSerializer " + ms.getClass().getName() + " to handle " + name));
        }
    }

    public Map getSerializerMap() {
        return serializerMap;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

