/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.XMLToObjectMapper;
import org.apache.synapse.config.xml.AggregateMediatorFactory;
import org.apache.synapse.config.xml.AnnotatedCommandMediatorFactory;
import org.apache.synapse.config.xml.CacheMediatorFactory;
import org.apache.synapse.config.xml.CalloutMediatorFactory;
import org.apache.synapse.config.xml.ClassMediatorFactory;
import org.apache.synapse.config.xml.CloneMediatorFactory;
import org.apache.synapse.config.xml.DBLookupMediatorFactory;
import org.apache.synapse.config.xml.DBReportMediatorFactory;
import org.apache.synapse.config.xml.DropMediatorFactory;
import org.apache.synapse.config.xml.FaultMediatorFactory;
import org.apache.synapse.config.xml.FilterMediatorFactory;
import org.apache.synapse.config.xml.HeaderMediatorFactory;
import org.apache.synapse.config.xml.InMediatorFactory;
import org.apache.synapse.config.xml.IterateMediatorFactory;
import org.apache.synapse.config.xml.LogMediatorFactory;
import org.apache.synapse.config.xml.MediatorFactory;
import org.apache.synapse.config.xml.OutMediatorFactory;
import org.apache.synapse.config.xml.POJOCommandMediatorFactory;
import org.apache.synapse.config.xml.PropertyMediatorFactory;
import org.apache.synapse.config.xml.RMSequenceMediatorFactory;
import org.apache.synapse.config.xml.SendMediatorFactory;
import org.apache.synapse.config.xml.SequenceMediatorFactory;
import org.apache.synapse.config.xml.SwitchMediatorFactory;
import org.apache.synapse.config.xml.SynapseMediatorFactory;
import org.apache.synapse.config.xml.ValidateMediatorFactory;
import org.apache.synapse.config.xml.XSLTMediatorFactory;
import sun.misc.Service;

public class MediatorFactoryFinder
implements XMLToObjectMapper {
    private static final Log log = LogFactory.getLog(MediatorFactoryFinder.class);
    private static final Class[] mediatorFactories = new Class[]{SequenceMediatorFactory.class, LogMediatorFactory.class, SendMediatorFactory.class, FilterMediatorFactory.class, SynapseMediatorFactory.class, DropMediatorFactory.class, HeaderMediatorFactory.class, FaultMediatorFactory.class, PropertyMediatorFactory.class, SwitchMediatorFactory.class, InMediatorFactory.class, OutMediatorFactory.class, RMSequenceMediatorFactory.class, ClassMediatorFactory.class, ValidateMediatorFactory.class, XSLTMediatorFactory.class, AnnotatedCommandMediatorFactory.class, POJOCommandMediatorFactory.class, CloneMediatorFactory.class, IterateMediatorFactory.class, AggregateMediatorFactory.class, DBReportMediatorFactory.class, DBLookupMediatorFactory.class, CacheMediatorFactory.class, CalloutMediatorFactory.class};
    private static MediatorFactoryFinder instance = null;
    private static Map factoryMap = new HashMap();

    public static synchronized MediatorFactoryFinder getInstance() {
        if (instance == null) {
            instance = new MediatorFactoryFinder();
        }
        return instance;
    }

    public synchronized void reset() {
        factoryMap.clear();
        instance = null;
    }

    private MediatorFactoryFinder() {
        factoryMap = new HashMap();
        for (int i = 0; i < mediatorFactories.length; ++i) {
            Class c = mediatorFactories[i];
            try {
                MediatorFactory fac = (MediatorFactory)c.newInstance();
                factoryMap.put(fac.getTagQName(), c);
                continue;
            }
            catch (Exception e) {
                throw new SynapseException("Error instantiating " + c.getName(), e);
            }
        }
        this.registerExtensions();
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private void registerExtensions() {
        Iterator it = Service.providers(MediatorFactory.class);
        while (it.hasNext()) {
            MediatorFactory mf = (MediatorFactory)it.next();
            QName tag = mf.getTagQName();
            factoryMap.put(tag, mf.getClass());
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Added MediatorFactory " + mf.getClass() + " to handle " + tag));
        }
    }

    public Mediator getMediator(OMElement element) {
        Class cls;
        String localName = element.getLocalName();
        QName qName = null;
        qName = element.getNamespace() != null ? new QName(element.getNamespace().getNamespaceURI(), localName) : new QName(localName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMediator(" + qName + ")"));
        }
        if ((cls = (Class)factoryMap.get(qName)) == null && localName.indexOf(46) > -1) {
            String newLocalName = localName.substring(0, localName.indexOf(46));
            qName = new QName(element.getNamespace().getNamespaceURI(), newLocalName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("getMediator.2(" + qName + ")"));
            }
            cls = (Class)factoryMap.get(qName);
        }
        if (cls == null) {
            String msg = "Unknown mediator referenced by configuration element : " + qName;
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        try {
            MediatorFactory mf = (MediatorFactory)cls.newInstance();
            return mf.createMediator(element);
        }
        catch (InstantiationException e) {
            String msg = "Error initializing mediator factory : " + cls;
            log.error((Object)msg);
            throw new SynapseException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Error initializing mediator factory : " + cls;
            log.error((Object)msg);
            throw new SynapseException(msg, e);
        }
    }

    public Map getFactoryMap() {
        return factoryMap;
    }

    public Object getObjectFromOMNode(OMNode om) {
        if (om instanceof OMElement) {
            return this.getMediator((OMElement)om);
        }
        this.handleException("Invalid mediator configuration XML : " + om);
        return null;
    }
}

