/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractListMediatorSerializer;
import org.apache.synapse.mediators.filters.FilterMediator;

public class FilterMediatorSerializer
extends AbstractListMediatorSerializer {
    public OMElement serializeMediator(OMElement parent, Mediator m) {
        if (!(m instanceof FilterMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        FilterMediator mediator = (FilterMediator)m;
        OMElement filter = fac.createOMElement("filter", synNS);
        if (mediator.getSource() != null && mediator.getRegex() != null) {
            filter.addAttribute(fac.createOMAttribute("source", nullNS, mediator.getSource().toString()));
            super.serializeNamespaces(filter, mediator.getSource());
            filter.addAttribute(fac.createOMAttribute("regex", nullNS, mediator.getRegex().pattern()));
        } else if (mediator.getXpath() != null) {
            filter.addAttribute(fac.createOMAttribute("xpath", nullNS, mediator.getXpath().toString()));
            super.serializeNamespaces(filter, mediator.getXpath());
        } else {
            this.handleException("Invalid filter mediator. Should have either a 'source' and a 'regex' OR an 'xpath' ");
        }
        FilterMediatorSerializer.saveTracingState(filter, mediator);
        this.serializeChildren(filter, mediator.getList());
        if (parent != null) {
            parent.addChild((OMNode)filter);
        }
        return filter;
    }

    public String getMediatorClassName() {
        return FilterMediator.class.getName();
    }
}

