/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.truezip;

import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.impl.DefaultFileSystemManager;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.LayeredFileName;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.truezip.TzFileSystem;
import org.apache.commons.vfs.util.RandomAccessMode;

public class TzFileObject
extends AbstractFileObject
implements FileObject {
    private de.schlichtherle.io.File tzFile;
    private FileObject vfsFile;

    protected TzFileObject(TzFileSystem fileSystem, FileName name) throws FileSystemException {
        super(name, fileSystem);
    }

    protected de.schlichtherle.io.File getLocalFile() {
        return this.tzFile;
    }

    protected void doAttach() throws Exception {
        if (this.tzFile == null) {
            LayeredFileName layeredFileName = (LayeredFileName)this.getName();
            String fileName = layeredFileName.getOuterName().getRootURI() + layeredFileName.getOuterName().getPathDecoded();
            FileObject outer = this.getFileSystem().resolveFile(fileName);
            if (outer instanceof TzFileObject) {
                fileName = layeredFileName.getOuterName().getPathDecoded() + this.getName().getPathDecoded();
                this.tzFile = new de.schlichtherle.io.File(fileName, (ArchiveDetector)ArchiveDetector.ALL);
            } else {
                this.vfsFile = outer;
                DefaultFileSystemManager dfsMgr = (DefaultFileSystemManager)VFS.getManager();
                this.tzFile = new de.schlichtherle.io.File(dfsMgr.getTemporaryFileStore().allocateFile(this.getName().getBaseName()));
            }
        }
    }

    protected FileType doGetType() throws Exception {
        if (this.vfsFile != null) {
            return this.vfsFile.getType();
        }
        if (!this.tzFile.exists() && this.tzFile.length() < 1L) {
            return FileType.IMAGINARY;
        }
        if (this.tzFile.isDirectory()) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    protected String[] doListChildren() throws Exception {
        return UriParser.encode(this.tzFile.list());
    }

    protected void doDelete() throws Exception {
        if (!this.tzFile.deleteAll()) {
            throw new FileSystemException("vfs.provider.truezip/delete-file.error", this.tzFile);
        }
    }

    protected void doRename(FileObject newfile) throws Exception {
        if (!this.tzFile.renameTo((File)((TzFileObject)newfile).getLocalFile())) {
            throw new FileSystemException("vfs.provider.truezip/rename-file.error", new String[]{this.tzFile.toString(), newfile.toString()});
        }
    }

    protected void doCreateFolder() throws Exception {
        if (!this.tzFile.mkdirs()) {
            throw new FileSystemException("vfs.provider.truezip/create-folder.error", this.tzFile);
        }
    }

    protected boolean doIsWriteable() throws FileSystemException {
        return this.tzFile.canWrite();
    }

    protected boolean doIsHidden() {
        return this.tzFile.isHidden();
    }

    protected boolean doIsReadable() throws FileSystemException {
        return this.tzFile.canRead();
    }

    protected long doGetLastModifiedTime() throws FileSystemException {
        return this.tzFile.lastModified();
    }

    protected void doSetLastModifiedTime(long modtime) throws FileSystemException {
        this.tzFile.setLastModified(modtime);
    }

    protected InputStream doGetInputStream() throws Exception {
        return new FileInputStream((File)this.tzFile);
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        return new FileOutputStream((File)this.tzFile, bAppend);
    }

    protected long doGetContentSize() throws Exception {
        return this.tzFile.length();
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        throw new IOException("Not implemented");
    }
}

