/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.bsf;

import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.mediators.bsf.ScriptMediator;

public class ScriptMediatorSerializer
extends AbstractMediatorSerializer {
    private static final Log log = LogFactory.getLog(ScriptMediatorSerializer.class);

    public OMElement serializeMediator(OMElement parent, Mediator m) {
        if (!(m instanceof ScriptMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        ScriptMediator scriptMediator = (ScriptMediator)m;
        OMElement script = fac.createOMElement("script", synNS);
        String language = scriptMediator.getLanguage();
        String key = scriptMediator.getKey();
        String function = scriptMediator.getFunction();
        if (key != null) {
            script.addAttribute(fac.createOMAttribute("language", nullNS, language));
            script.addAttribute(fac.createOMAttribute("key", nullNS, key));
            if (!function.equals("mediate")) {
                script.addAttribute(fac.createOMAttribute("function", nullNS, function));
            }
        } else {
            script.addAttribute(fac.createOMAttribute("language", nullNS, language));
            OMTextImpl textData = (OMTextImpl)fac.createOMText(scriptMediator.getScriptSrc().trim());
            textData.setType(12);
            script.addChild((OMNode)textData);
        }
        Map includeMap = scriptMediator.getIncludeMap();
        for (String includeKey : includeMap.keySet()) {
            OMElement includeKeyElement = fac.createOMElement("include", synNS);
            includeKeyElement.addAttribute(fac.createOMAttribute("key", nullNS, includeKey));
            script.addChild((OMNode)includeKeyElement);
        }
        ScriptMediatorSerializer.saveTracingState((OMElement)script, (Mediator)scriptMediator);
        if (parent != null) {
            parent.addChild((OMNode)script);
        }
        return script;
    }

    public String getMediatorClassName() {
        return ScriptMediator.class.getName();
    }
}

