/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.bsf;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.mediators.bsf.ScriptMediator;

public class ScriptMediatorFactory
extends AbstractMediatorFactory {
    private static final QName TAG_NAME = new QName("http://ws.apache.org/ns/synapse", "script");
    private static final QName INCLUDE_Q = new QName("http://ws.apache.org/ns/synapse", "include");

    public Mediator createMediator(OMElement elem) {
        ScriptMediator mediator;
        OMAttribute keyAtt = elem.getAttribute(new QName("", "key"));
        OMAttribute langAtt = elem.getAttribute(new QName("", "language"));
        OMAttribute funcAtt = elem.getAttribute(new QName("", "function"));
        if (langAtt == null) {
            throw new SynapseException("The 'language' attribute is required for a script mediator");
        }
        if (keyAtt == null && funcAtt != null) {
            throw new SynapseException("Cannot use 'function' attribute without 'key' attribute for a script mediator");
        }
        Map includeKeysMap = this.getIncludeKeysMap(elem);
        if (keyAtt != null) {
            String functionName = funcAtt == null ? null : funcAtt.getAttributeValue();
            mediator = new ScriptMediator(langAtt.getAttributeValue(), includeKeysMap, keyAtt.getAttributeValue(), functionName);
        } else {
            mediator = new ScriptMediator(langAtt.getAttributeValue(), elem.getText());
        }
        this.processTraceState((Mediator)mediator, elem);
        return mediator;
    }

    private Map getIncludeKeysMap(OMElement elem) {
        TreeMap<String, Object> includeKeysMap = new TreeMap<String, Object>();
        Iterator iter = elem.getChildrenWithName(INCLUDE_Q);
        while (iter.hasNext()) {
            OMElement includeElem = (OMElement)iter.next();
            OMAttribute key = includeElem.getAttribute(new QName("", "key"));
            if (key == null) {
                throw new SynapseException("Cannot use 'include' element without 'key' attribute for a script mediator");
            }
            String keyText = key.getAttributeValue();
            includeKeysMap.put(keyText, null);
        }
        return includeKeysMap;
    }

    public QName getTagQName() {
        return TAG_NAME;
    }
}

