/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.throttle.impl.ipbase;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.throttle.CallerConfiguration;
import org.wso2.throttle.ThrottleConfiguration;
import org.wso2.throttle.impl.ipbase.IPBaseCallerConfiguration;

public class IPBaseThrottleConfiguration
implements ThrottleConfiguration {
    private static Log log = LogFactory.getLog((String)IPBaseThrottleConfiguration.class.getName());
    private String keyOfOther;
    private CallerConfiguration defaultCallerConfiguration;
    private Map configurationsMap = new HashMap();

    public CallerConfiguration getCallerConfiguration(String ID) {
        if (ID.equals("other")) {
            return this.defaultCallerConfiguration;
        }
        String key = this.getConfigurationKeyOfCaller(ID);
        if (key != null) {
            if (key.equals("other")) {
                return this.defaultCallerConfiguration;
            }
            return (CallerConfiguration)this.configurationsMap.get(key);
        }
        return null;
    }

    public void addCallerConfiguration(CallerConfiguration configuration) {
        IPBaseCallerConfiguration ipBaseCallerConfiguration = (IPBaseCallerConfiguration)configuration;
        String key = ipBaseCallerConfiguration.getFirstPartOfIPRange();
        if (key == null) {
            return;
        }
        if (key.equals("other")) {
            this.keyOfOther = "other";
            this.defaultCallerConfiguration = ipBaseCallerConfiguration;
        } else {
            this.configurationsMap.put(key, ipBaseCallerConfiguration);
        }
    }

    public String getConfigurationKeyOfCaller(String callerID) {
        if (callerID != null) {
            if (this.configurationsMap.containsKey(callerID)) {
                return callerID;
            }
            int index = callerID.lastIndexOf(".");
            if (index > 0) {
                Set keys;
                String net = callerID.substring(0, index);
                String host = callerID.substring(index + 1, callerID.length());
                if (net != null && host != null && (keys = this.configurationsMap.keySet()) != null && !keys.isEmpty()) {
                    Iterator it = keys.iterator();
                    while (it.hasNext()) {
                        String secondPart;
                        IPBaseCallerConfiguration con;
                        String key = (String)it.next();
                        if (key == null || !key.startsWith(net) || !this.isAfter(key, host) || (con = (IPBaseCallerConfiguration)this.configurationsMap.get(key)) == null || (secondPart = con.getSecondPartOfIPRange()) == null || !this.isBefore(secondPart, host)) continue;
                        return key;
                    }
                    String all = net + ".*";
                    if (this.configurationsMap.containsKey(all)) {
                        return all;
                    }
                }
            }
        }
        return this.keyOfOther;
    }

    private boolean isAfter(String ip, String host) {
        String hostfromip;
        int index = ip.lastIndexOf(".");
        if (index > 0 && (hostfromip = ip.substring(index + 1, ip.length())) != null) {
            return Integer.parseInt(hostfromip) <= Integer.parseInt(host);
        }
        return false;
    }

    private boolean isBefore(String ip, String host) {
        String hostfromip;
        int index = ip.lastIndexOf(".");
        if (index > 0 && (hostfromip = ip.substring(index + 1, ip.length())) != null) {
            return Integer.parseInt(hostfromip) >= Integer.parseInt(host);
        }
        return false;
    }

    public int getType() {
        return 0;
    }
}

