/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.IOMRMPart;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.LastMessage;
import org.apache.sandesha2.wsrm.MessageNumber;

public class Sequence
implements IOMRMPart {
    private Identifier identifier;
    private MessageNumber messageNumber;
    private LastMessage lastMessage = null;
    private String namespaceValue = null;

    public Sequence(String namespaceValue) throws SandeshaException {
        if (!this.isNamespaceSupported(namespaceValue)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", namespaceValue));
        }
        this.namespaceValue = namespaceValue;
    }

    public String getNamespaceValue() {
        return this.namespaceValue;
    }

    public Object fromOMElement(OMElement headerElement) throws OMException, SandeshaException {
        SOAPHeader header = (SOAPHeader)headerElement;
        if (header == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("seqElementCannotBeAddedToNonHeader"));
        }
        OMElement sequencePart = headerElement.getFirstChildWithName(new QName(this.namespaceValue, "Sequence"));
        if (sequencePart == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("noSequencePartInElement", headerElement.toString()));
        }
        this.identifier = new Identifier(this.namespaceValue);
        this.messageNumber = new MessageNumber(this.namespaceValue);
        this.identifier.fromOMElement(sequencePart);
        this.messageNumber.fromOMElement(sequencePart);
        OMElement lastMessageElement = sequencePart.getFirstChildWithName(new QName(this.namespaceValue, "LastMessage"));
        if (lastMessageElement != null) {
            this.lastMessage = new LastMessage(this.namespaceValue);
            this.lastMessage.fromOMElement(sequencePart);
        }
        ((SOAPHeaderBlock)sequencePart).setProcessed();
        return this;
    }

    public OMElement toOMElement(OMElement headerElement) throws OMException {
        if (headerElement == null || !(headerElement instanceof SOAPHeader)) {
            throw new OMException(SandeshaMessageHelper.getMessage("seqElementCannotBeAddedToNonHeader"));
        }
        SOAPHeader soapHeader = (SOAPHeader)headerElement;
        if (this.identifier == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("nullMsgId"));
        }
        if (this.messageNumber == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("seqPartIsNull"));
        }
        OMFactory factory = headerElement.getOMFactory();
        OMNamespace rmNamespace = factory.createOMNamespace(this.namespaceValue, "wsrm");
        SOAPHeaderBlock sequenceHeaderBlock = soapHeader.addHeaderBlock("Sequence", rmNamespace);
        sequenceHeaderBlock.setMustUnderstand(true);
        this.identifier.toOMElement((OMElement)sequenceHeaderBlock);
        this.messageNumber.toOMElement((OMElement)sequenceHeaderBlock);
        if (this.lastMessage != null) {
            this.lastMessage.toOMElement((OMElement)sequenceHeaderBlock);
        }
        return headerElement;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public LastMessage getLastMessage() {
        return this.lastMessage;
    }

    public MessageNumber getMessageNumber() {
        return this.messageNumber;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public void setLastMessage(LastMessage lastMessage) {
        this.lastMessage = lastMessage;
    }

    public void setMessageNumber(MessageNumber messageNumber) {
        this.messageNumber = messageNumber;
    }

    public void toSOAPEnvelope(SOAPEnvelope envelope) {
        OMElement elem;
        SOAPHeader header = envelope.getHeader();
        if (header == null) {
            SOAPFactory factory = (SOAPFactory)envelope.getOMFactory();
            header = factory.createSOAPHeader(envelope);
        }
        if ((elem = header.getFirstChildWithName(new QName(this.namespaceValue, "Sequence"))) != null) {
            elem.detach();
        }
        this.toOMElement((OMElement)header);
    }

    public boolean isNamespaceSupported(String namespaceName) {
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceName)) {
            return true;
        }
        return "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceName);
    }
}

