/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.IOMRMElement;

public class AcknowledgementRange
implements IOMRMElement {
    private long upperValue;
    private long lowerValue;
    private String namespaceValue = null;

    public AcknowledgementRange(String namespaceValue) throws SandeshaException {
        if (!this.isNamespaceSupported(namespaceValue)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", namespaceValue));
        }
        this.namespaceValue = namespaceValue;
    }

    public String getNamespaceValue() {
        return this.namespaceValue;
    }

    public Object fromOMElement(OMElement ackRangePart) throws OMException {
        if (ackRangePart == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("nullPassedElement"));
        }
        OMAttribute lowerAttrib = ackRangePart.getAttribute(new QName("Lower"));
        OMAttribute upperAttrib = ackRangePart.getAttribute(new QName("Upper"));
        if (lowerAttrib == null || upperAttrib == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("noUpperOrLowerAttributesInElement", ackRangePart.toString()));
        }
        try {
            long upper;
            long lower = Long.parseLong(lowerAttrib.getAttributeValue());
            this.upperValue = upper = Long.parseLong(upperAttrib.getAttributeValue());
            this.lowerValue = lower;
        }
        catch (Exception ex) {
            throw new OMException(SandeshaMessageHelper.getMessage("ackRandDoesNotHaveCorrectValues", ackRangePart.toString()));
        }
        return this;
    }

    public OMElement toOMElement(OMElement sequenceAckElement) throws OMException {
        if (sequenceAckElement == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("cannotSetAckRangeNullElement"));
        }
        if (this.upperValue <= 0L || this.lowerValue <= 0L || this.lowerValue > this.upperValue) {
            throw new OMException(SandeshaMessageHelper.getMessage("ackRandDoesNotHaveCorrectValues", this.upperValue + ":" + this.lowerValue));
        }
        OMFactory factory = sequenceAckElement.getOMFactory();
        OMAttribute lowerAttrib = factory.createOMAttribute("Lower", null, Long.toString(this.lowerValue));
        OMAttribute upperAttrib = factory.createOMAttribute("Upper", null, Long.toString(this.upperValue));
        OMNamespace rmNamespace = factory.createOMNamespace(this.namespaceValue, "wsrm");
        OMElement acknowledgementRangeElement = factory.createOMElement("AcknowledgementRange", rmNamespace);
        acknowledgementRangeElement.addAttribute(lowerAttrib);
        acknowledgementRangeElement.addAttribute(upperAttrib);
        sequenceAckElement.addChild((OMNode)acknowledgementRangeElement);
        return sequenceAckElement;
    }

    public long getLowerValue() {
        return this.lowerValue;
    }

    public void setLowerValue(long lowerValue) {
        this.lowerValue = lowerValue;
    }

    public long getUpperValue() {
        return this.upperValue;
    }

    public void setUpperValue(long upperValue) {
        this.upperValue = upperValue;
    }

    public boolean isNamespaceSupported(String namespaceName) {
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceName)) {
            return true;
        }
        return "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceName);
    }
}

