/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.truezip;

import de.schlichtherle.io.ArchiveException;
import java.io.File;
import java.io.FilePermission;
import java.util.Collection;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.truezip.TzFileObject;
import org.apache.commons.vfs.provider.truezip.TzFileProvider;

public class TzFileSystem
extends AbstractFileSystem
implements FileSystem {
    public TzFileSystem(FileName rootName, String rootFile, FileSystemOptions opts) {
        super(rootName, null, opts);
    }

    protected TzFileSystem(FileName rootName, FileObject file, FileSystemOptions fileSystemOptions) throws FileSystemException {
        super(rootName, file, fileSystemOptions);
    }

    protected FileObject createFile(FileName name) throws FileSystemException {
        return new TzFileObject(this, name);
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(TzFileProvider.capabilities);
    }

    protected File doReplicateFile(FileObject fileObject, FileSelector selector) throws Exception {
        TzFileObject localFile = (TzFileObject)fileObject;
        de.schlichtherle.io.File file = localFile.getLocalFile();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            FilePermission requiredPerm = new FilePermission(file.getAbsolutePath(), "read");
            sm.checkPermission(requiredPerm);
        }
        return file;
    }

    protected void doCloseCommunicationLink() {
        try {
            de.schlichtherle.io.File.umount();
        }
        catch (ArchiveException e) {
            throw new RuntimeException(e);
        }
    }
}

