/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20.extensions.soap;

import javax.xml.namespace.QName;
import org.apache.woden.ErrorLocator;
import org.apache.woden.WSDLException;
import org.apache.woden.XMLElement;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.internal.util.QNameUtils;
import org.apache.woden.internal.wsdl20.Constants;
import org.apache.woden.internal.wsdl20.extensions.soap.SOAPHeaderBlockImpl;
import org.apache.woden.wsdl20.extensions.ExtensionDeserializer;
import org.apache.woden.wsdl20.extensions.ExtensionElement;
import org.apache.woden.wsdl20.extensions.ExtensionRegistry;
import org.apache.woden.wsdl20.extensions.soap.SOAPHeaderBlockElement;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.apache.woden.wsdl20.xml.DocumentableElement;
import org.apache.woden.wsdl20.xml.DocumentationElement;
import org.apache.woden.wsdl20.xml.WSDLElement;

public class SOAPHeaderBlockDeserializer
implements ExtensionDeserializer {
    public ExtensionElement unmarshall(Class parentType, Object parent, QName extType, XMLElement extEl, DescriptionElement desc, ExtensionRegistry extReg) throws WSDLException {
        SOAPHeaderBlockElement soapHdr = (SOAPHeaderBlockElement)extReg.createExtElement(parentType, extType);
        soapHdr.setExtensionType(extType);
        soapHdr.setParentElement((WSDLElement)parent);
        String elemDeclQN = extEl.getAttributeValue("element");
        if (elemDeclQN != null) {
            try {
                QName qname = extEl.getQName(elemDeclQN);
                soapHdr.setElementName(qname);
            }
            catch (WSDLException e) {
                extReg.getErrorReporter().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL505", new Object[]{elemDeclQN, extEl.getLocalName()}, (short)2);
            }
        }
        String mustUnderstand = extEl.getAttributeValue("mustUnderstand");
        soapHdr.setMustUnderstand(new Boolean(mustUnderstand));
        String required = extEl.getAttributeValue("required");
        soapHdr.setRequired(new Boolean(required));
        ((SOAPHeaderBlockImpl)soapHdr).setTypes(desc.getTypesElement());
        for (XMLElement tempEl = extEl.getFirstChildElement(); tempEl != null; tempEl = tempEl.getNextSiblingElement()) {
            if (!QNameUtils.matches(Constants.Q_ELEM_DOCUMENTATION, tempEl)) continue;
            soapHdr.addDocumentationElement(this.parseDocumentation(tempEl, desc));
        }
        return soapHdr;
    }

    private DocumentationElement parseDocumentation(XMLElement docEl, DocumentableElement parent) throws WSDLException {
        DocumentationElement documentation = parent.addDocumentationElement();
        documentation.setContent(docEl);
        return documentation;
    }
}

