/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.util.dom;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.woden.ErrorLocator;
import org.apache.woden.WSDLException;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.internal.ErrorReporterImpl;
import org.apache.woden.internal.util.dom.DOMQNameUtils;
import org.apache.woden.internal.util.dom.XPathUtils;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMUtils {
    private static String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";
    private static final String ATTR_XMLNS = "xmlns";
    private static final String emptyString = "";

    public static List getAttributes(Element el) {
        String prefix = null;
        Vector<Node> attrs = new Vector<Node>();
        NamedNodeMap attrMap = el.getAttributes();
        for (int i = 0; i < attrMap.getLength(); ++i) {
            String nodename = attrMap.item(i).getNodeName();
            prefix = attrMap.item(i).getPrefix();
            if (ATTR_XMLNS.equals(nodename) || ATTR_XMLNS.equals(prefix)) continue;
            attrs.add(attrMap.item(i));
        }
        return attrs;
    }

    public static String getAttribute(Element el, String attrName) {
        String sRet = null;
        Attr attr = el.getAttributeNode(attrName);
        if (attr != null) {
            sRet = attr.getValue();
        }
        return sRet;
    }

    public static String getAttribute(Element el, String attrName, List remainingAttrs) {
        String sRet = null;
        Attr attr = el.getAttributeNode(attrName);
        if (attr != null) {
            sRet = attr.getValue();
            remainingAttrs.remove(attr);
        }
        return sRet;
    }

    public static String getAttributeNS(Element el, String namespaceURI, String localPart) {
        String sRet = null;
        Attr attr = el.getAttributeNodeNS(namespaceURI, localPart);
        if (attr != null) {
            sRet = attr.getValue();
        }
        return sRet;
    }

    public static String getChildCharacterData(Element parentEl) {
        if (parentEl == null) {
            return null;
        }
        StringBuffer strBuf = new StringBuffer();
        for (Node tempNode = parentEl.getFirstChild(); tempNode != null; tempNode = tempNode.getNextSibling()) {
            switch (tempNode.getNodeType()) {
                case 3: 
                case 4: {
                    CharacterData charData = (CharacterData)tempNode;
                    strBuf.append(charData.getData());
                }
            }
        }
        return strBuf.toString();
    }

    public static Element getFirstChildElement(Element elem) {
        for (Node n = elem.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public static Element getNextSiblingElement(Element elem) {
        for (Node n = elem.getNextSibling(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public static Element findChildElementWithAttribute(Element elem, String attrName, String attrValue) {
        for (Node n = elem.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 || !attrValue.equals(DOMUtils.getAttribute((Element)n, attrName))) continue;
            return (Element)n;
        }
        return null;
    }

    public static int countKids(Element elem, short nodeType) {
        int nkids = 0;
        for (Node n = elem.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != nodeType) continue;
            ++nkids;
        }
        return nkids;
    }

    public static String getNamespaceURIFromPrefix(Node context, String prefix) {
        short nodeType = context.getNodeType();
        Node tempNode = null;
        switch (nodeType) {
            case 2: {
                tempNode = ((Attr)context).getOwnerElement();
                break;
            }
            case 1: {
                tempNode = context;
                break;
            }
            default: {
                tempNode = context.getParentNode();
            }
        }
        while (tempNode != null && tempNode.getNodeType() == 1) {
            String namespaceURI;
            Element tempEl = (Element)tempNode;
            String string = namespaceURI = prefix == null ? DOMUtils.getAttribute(tempEl, ATTR_XMLNS) : DOMUtils.getAttributeNS(tempEl, NS_URI_XMLNS, prefix);
            if (namespaceURI != null) {
                return namespaceURI;
            }
            tempNode = tempEl.getParentNode();
        }
        return null;
    }

    public static QName getQName(String prefixedValue, Element contextEl) throws WSDLException {
        int index = prefixedValue.indexOf(58);
        String prefix = index != -1 ? prefixedValue.substring(0, index) : null;
        String localPart = prefixedValue.substring(index + 1);
        String namespaceURI = DOMUtils.getNamespaceURIFromPrefix(contextEl, prefix);
        if (namespaceURI != null) {
            return new QName(namespaceURI, localPart, prefix != null ? prefix : emptyString);
        }
        String faultCode = prefix == null ? "NO_PREFIX_SPECIFIED" : "UNBOUND_PREFIX";
        WSDLException wsdlExc = new WSDLException(faultCode, "Unable to determine namespace of '" + prefixedValue + "'.");
        wsdlExc.setLocation(XPathUtils.getXPathExprFromNode(contextEl));
        throw wsdlExc;
    }

    public static QName getQName(String prefixedValue, Element contextEl, DescriptionElement desc) throws WSDLException {
        int index = prefixedValue.indexOf(58);
        String prefix = index != -1 ? prefixedValue.substring(0, index) : null;
        String localPart = prefixedValue.substring(index + 1);
        String namespaceURI = DOMUtils.getNamespaceURIFromPrefix(contextEl, prefix);
        if (namespaceURI != null) {
            DOMUtils.registerUniquePrefix(prefix, namespaceURI, desc);
            return new QName(namespaceURI, localPart, prefix != null ? prefix : emptyString);
        }
        String faultCode = prefix == null ? "NO_PREFIX_SPECIFIED" : "UNBOUND_PREFIX";
        WSDLException wsdlExc = new WSDLException(faultCode, "Unable to determine namespace of '" + prefixedValue + "'.");
        wsdlExc.setLocation(XPathUtils.getXPathExprFromNode(contextEl));
        throw wsdlExc;
    }

    public static void registerUniquePrefix(String prefix, String namespaceURI, DescriptionElement desc) throws WSDLException {
        String tempNSUri;
        URI nsUri = desc.getNamespace(prefix);
        String string = tempNSUri = nsUri != null ? nsUri.toString() : null;
        if (tempNSUri != null && tempNSUri.equals(namespaceURI)) {
            return;
        }
        while (tempNSUri != null && !tempNSUri.equals(namespaceURI)) {
            nsUri = desc.getNamespace(prefix = prefix + "_");
            tempNSUri = nsUri != null ? nsUri.toString() : null;
        }
        URI uri = null;
        try {
            uri = new URI(namespaceURI);
        }
        catch (URISyntaxException e) {
            new ErrorReporterImpl().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL506", new Object[]{namespaceURI}, (short)2, (Exception)e);
        }
        desc.addNamespace(prefix, uri);
    }

    public static void throwWSDLException(Element location) throws WSDLException {
        String elName = DOMQNameUtils.newQName(location).toString();
        WSDLException wsdlExc = new WSDLException("INVALID_WSDL", "Encountered unexpected element '" + elName + "'.");
        wsdlExc.setLocation(XPathUtils.getXPathExprFromNode(location));
        throw wsdlExc;
    }

    public static void throwWSDLException(Element location, List remainingAttrs) throws WSDLException {
        String elName = DOMQNameUtils.newQName(location).toString();
        StringBuffer sb = new StringBuffer();
        ListIterator i = remainingAttrs.listIterator();
        while (i.hasNext()) {
            String attrName = DOMQNameUtils.newQName((Attr)i.next()).toString();
            sb.append(attrName);
            sb.append(i.hasNext() ? " " : emptyString);
        }
        WSDLException wsdlExc = new WSDLException("INVALID_WSDL", "Element '" + elName + "' contained unexpected attributes: '" + sb.toString() + "'");
        wsdlExc.setLocation(XPathUtils.getXPathExprFromNode(location));
        throw wsdlExc;
    }
}

