/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jam.internal.elements;

import java.io.StringWriter;
import java.lang.reflect.Modifier;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JParameter;
import org.codehaus.jam.internal.classrefs.DirectJClassRef;
import org.codehaus.jam.internal.classrefs.JClassRef;
import org.codehaus.jam.internal.classrefs.QualifiedJClassRef;
import org.codehaus.jam.internal.classrefs.UnqualifiedJClassRef;
import org.codehaus.jam.internal.elements.ClassImpl;
import org.codehaus.jam.internal.elements.InvokableImpl;
import org.codehaus.jam.mutable.MMethod;
import org.codehaus.jam.visitor.JVisitor;
import org.codehaus.jam.visitor.MVisitor;

public final class MethodImpl
extends InvokableImpl
implements MMethod {
    private JClassRef mReturnTypeRef = null;

    MethodImpl(String simpleName, ClassImpl containingClass) {
        super(containingClass);
        this.setSimpleName(simpleName);
    }

    public void setReturnType(String className) {
        this.mReturnTypeRef = QualifiedJClassRef.create(className, (ClassImpl)this.getContainingClass());
    }

    public void setUnqualifiedReturnType(String unqualifiedTypeName) {
        this.mReturnTypeRef = UnqualifiedJClassRef.create(unqualifiedTypeName, (ClassImpl)this.getContainingClass());
    }

    public void setReturnType(JClass c) {
        this.mReturnTypeRef = DirectJClassRef.create(c);
    }

    public JClass getReturnType() {
        if (this.mReturnTypeRef == null) {
            return this.getClassLoader().loadClass("void");
        }
        return this.mReturnTypeRef.getRefClass();
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public boolean isNative() {
        return Modifier.isNative(this.getModifiers());
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.getModifiers());
    }

    public void accept(MVisitor visitor) {
        visitor.visit(this);
    }

    public void accept(JVisitor visitor) {
        visitor.visit(this);
    }

    public String getQualifiedName() {
        int i;
        StringWriter sbuf = new StringWriter();
        sbuf.write(Modifier.toString(this.getModifiers()));
        sbuf.write(32);
        JClass returnJClass = this.getReturnType();
        if (returnJClass == null) {
            sbuf.write("void ");
        } else {
            sbuf.write(returnJClass.getQualifiedName());
            sbuf.write(32);
        }
        sbuf.write(this.getSimpleName());
        sbuf.write(40);
        JParameter[] params = this.getParameters();
        if (params != null && params.length > 0) {
            for (i = 0; i < params.length; ++i) {
                sbuf.write(params[i].getType().getQualifiedName());
                if (i >= params.length - 1) continue;
                sbuf.write(44);
            }
        }
        sbuf.write(41);
        JClass[] thrown = this.getExceptionTypes();
        if (thrown != null && thrown.length > 0) {
            sbuf.write(" throws ");
            for (i = 0; i < thrown.length; ++i) {
                sbuf.write(thrown[i].getQualifiedName());
                if (i >= thrown.length - 1) continue;
                sbuf.write(44);
            }
        }
        return sbuf.toString();
    }
}

