/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DocumentBuilderImpl;

public class DocumentBuilderFactoryImpl
extends DocumentBuilderFactory {
    Configuration config = null;
    boolean xIncludeAware = false;

    public DocumentBuilderFactoryImpl() {
        this.setCoalescing(true);
        this.setExpandEntityReferences(true);
        this.setIgnoringComments(false);
        this.setIgnoringElementContentWhitespace(false);
        this.setNamespaceAware(true);
        this.setValidating(false);
    }

    public void setAttribute(String string, Object object) {
        if (string.equals("http://saxon.sf.net/feature/configuration")) {
            this.config = (Configuration)object;
        } else {
            if (this.config == null) {
                this.config = new Configuration();
            }
            this.config.setConfigurationProperty(string, object);
        }
    }

    public Object getAttribute(String string) {
        if (string.equals("http://saxon.sf.net/feature/configuration")) {
            return this.config;
        }
        if (this.config == null) {
            this.config = new Configuration();
        }
        return this.config.getConfigurationProperty(string);
    }

    public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        if (!this.isExpandEntityReferences()) {
            throw new ParserConfigurationException("Saxon parser always expands entity references");
        }
        if (this.isIgnoringComments()) {
            throw new ParserConfigurationException("Saxon parser does not allow comments to be ignored");
        }
        if (this.isIgnoringElementContentWhitespace()) {
            throw new ParserConfigurationException("Saxon parser does not allow whitespace in element content to be ignored");
        }
        if (!this.isNamespaceAware()) {
            throw new ParserConfigurationException("Saxon parser is always namespace aware");
        }
        DocumentBuilderImpl documentBuilderImpl = new DocumentBuilderImpl();
        documentBuilderImpl.setValidating(this.isValidating());
        documentBuilderImpl.setXIncludeAware(this.xIncludeAware);
        if (this.isIgnoringElementContentWhitespace()) {
            documentBuilderImpl.setStripSpace(11);
        }
        documentBuilderImpl.setConfiguration(this.config);
        return documentBuilderImpl;
    }

    public void setFeature(String string, boolean bl) throws ParserConfigurationException {
        if (!string.equals("http://javax.xml.XMLConstants/feature/secure-processing") || bl) {
            throw new ParserConfigurationException("Unsupported feature or value: " + string);
        }
    }

    public boolean getFeature(String string) throws ParserConfigurationException {
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return false;
        }
        throw new ParserConfigurationException("Unsupported feature: " + string);
    }

    public boolean isXIncludeAware() {
        return this.xIncludeAware;
    }

    public void setXIncludeAware(boolean bl) {
        this.xIncludeAware = bl;
    }
}

