/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SaxonLocator;
import net.sf.saxon.event.SourceLocationProvider;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class DOMSender
implements SaxonLocator,
SourceLocationProvider {
    private Receiver receiver;
    private PipelineConfiguration pipe;
    private NamespaceSupport nsSupport = new NamespaceSupport();
    private AttributesImpl attlist = new AttributesImpl();
    private String[] parts = new String[3];
    private String[] elparts = new String[3];
    private HashMap nsDeclarations = new HashMap(10);
    protected Node root = null;
    protected String systemId;

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        this.pipe = pipelineConfiguration;
    }

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public void setStartNode(Node node) {
        this.root = node;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public void send() throws XPathException {
        if (this.root == null) {
            throw new DynamicError("DOMSender: no start node defined");
        }
        if (this.receiver == null) {
            throw new DynamicError("DOMSender: no receiver defined");
        }
        this.receiver.setSystemId(this.systemId);
        this.pipe.setLocationProvider((LocationProvider)this);
        this.receiver.setPipelineConfiguration(this.pipe);
        this.receiver.open();
        if (this.root.getNodeType() == 1) {
            this.sendElement((Element)this.root);
        } else {
            this.receiver.startDocument(0);
            this.walkNode(this.root);
            this.receiver.endDocument();
        }
        this.receiver.close();
    }

    private void sendElement(Element element) throws XPathException {
        Element element2 = element;
        NamedNodeMap namedNodeMap = this.gatherNamespaces(element2, false);
        while (true) {
            this.gatherNamespaces(element2, true);
            Node node = element2.getParentNode();
            if (node == null || node.getNodeType() != 1) break;
            element2 = (Element)node;
        }
        this.outputElement(element, namedNodeMap);
    }

    private void walkNode(Node node) throws XPathException {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            block9: for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                switch (node2.getNodeType()) {
                    case 9: {
                        continue block9;
                    }
                    case 1: {
                        Element element = (Element)node2;
                        NamedNodeMap namedNodeMap = this.gatherNamespaces(element, false);
                        this.outputElement(element, namedNodeMap);
                        this.nsSupport.popContext();
                        continue block9;
                    }
                    case 2: {
                        continue block9;
                    }
                    case 7: {
                        this.receiver.processingInstruction(((ProcessingInstruction)node2).getTarget(), (CharSequence)((ProcessingInstruction)node2).getData(), 0, 0);
                        continue block9;
                    }
                    case 8: {
                        String string = ((Comment)node2).getData();
                        if (string == null) continue block9;
                        this.receiver.comment((CharSequence)string, 0, 0);
                        continue block9;
                    }
                    case 3: 
                    case 4: {
                        String string = ((CharacterData)node2).getData();
                        if (string == null) continue block9;
                        this.receiver.characters((CharSequence)string, 0, 0);
                        continue block9;
                    }
                    case 5: {
                        this.walkNode(node2);
                        continue block9;
                    }
                }
            }
        }
    }

    private void outputElement(Element element, NamedNodeMap namedNodeMap) throws XPathException {
        Object object;
        Configuration configuration = this.pipe.getConfiguration();
        String[] stringArray = this.nsSupport.processName(element.getTagName(), this.elparts, false);
        if (stringArray == null) {
            throw new DynamicError("Undeclared namespace in " + element.getTagName());
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = NameChecker.getPrefix((String)stringArray[2]);
        NamePool namePool = configuration.getNamePool();
        int n = namePool.allocate(string3, string, string2);
        this.receiver.startElement(n, 630, 0, 0);
        Iterator iterator = this.nsDeclarations.keySet().iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            object = (String)this.nsDeclarations.get(string4);
            this.receiver.namespace(namePool.allocateNamespaceCode(string4, (String)object), 0);
        }
        if (namedNodeMap != null) {
            int n2 = namedNodeMap.getLength();
            for (int i = 0; i < n2; ++i) {
                object = (Attr)namedNodeMap.item(i);
                String string5 = object.getName();
                if (string5.startsWith("xmlns") && (string5.equals("xmlns") || string5.startsWith("xmlns:"))) continue;
                String[] stringArray2 = this.nsSupport.processName(string5, this.parts, true);
                if (stringArray2 == null) {
                    throw new DynamicError("Undeclared namespace in " + string5);
                }
                String string6 = stringArray2[0];
                String string7 = stringArray2[1];
                String string8 = NameChecker.getPrefix((String)stringArray2[2]);
                int n3 = namePool.allocate(string8, string6, string7);
                this.receiver.attribute(n3, 631, (CharSequence)object.getValue(), 0, 0);
            }
        }
        this.receiver.startContent();
        this.walkNode(element);
        this.receiver.endElement();
    }

    private NamedNodeMap gatherNamespaces(Element element, boolean bl) {
        Object object;
        if (!bl) {
            this.nsSupport.pushContext();
            this.attlist.clear();
            this.nsDeclarations.clear();
        }
        try {
            object = element.getPrefix();
            String string = element.getNamespaceURI();
            if (object == null) {
                object = "";
            }
            if (string == null) {
                string = "";
            }
            if (this.nsDeclarations.get(object) == null) {
                this.nsSupport.declarePrefix((String)object, string);
                this.nsDeclarations.put(object, string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        object = element.getAttributes();
        if (object == null) {
            return null;
        }
        int n = object.getLength();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2;
            Attr attr = (Attr)object.item(i);
            String string3 = attr.getName();
            if (string3.equals("xmlns")) {
                if (this.nsDeclarations.get("") != null) continue;
                string2 = attr.getValue();
                this.nsSupport.declarePrefix("", string2);
                this.nsDeclarations.put("", string2);
                continue;
            }
            if (string3.startsWith("xmlns:")) {
                string2 = string3.substring(6);
                if (this.nsDeclarations.get(string2) != null) continue;
                string = attr.getValue();
                this.nsSupport.declarePrefix(string2, string);
                this.nsDeclarations.put(string2, string);
                continue;
            }
            if (string3.indexOf(58) < 0) continue;
            try {
                string2 = attr.getPrefix();
                string = attr.getNamespaceURI();
                if (this.nsDeclarations.get(string2) != null) continue;
                this.nsSupport.declarePrefix(string2, string);
                this.nsDeclarations.put(string2, string);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return object;
    }

    public int getColumnNumber() {
        return -1;
    }

    public int getLineNumber() {
        return -1;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getSystemId(int n) {
        return this.getSystemId();
    }

    public int getLineNumber(int n) {
        return this.getLineNumber();
    }
}

