/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.statistics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.synapse.statistics.StatisticsHolder;

public class StatisticsCollector {
    private Map sequenceStatistics = Collections.synchronizedMap(new HashMap());
    private Map endpointStatistics = Collections.synchronizedMap(new HashMap());
    private Map proxyServicesStatistics = Collections.synchronizedMap(new HashMap());

    public void reportForEndPoint(String keyOfStatistic, boolean isResponse, long inTime, long outTime, boolean isFault) {
        StatisticsHolder statisticsHolder = (StatisticsHolder)this.endpointStatistics.get(keyOfStatistic);
        if (statisticsHolder == null) {
            statisticsHolder = new StatisticsHolder();
            statisticsHolder.setKey(keyOfStatistic);
            statisticsHolder.setStatisticsCategory(2);
            this.endpointStatistics.put(keyOfStatistic, statisticsHolder);
        }
        statisticsHolder.update(isResponse, inTime, outTime, isFault);
    }

    public void reportForProxyService(String keyOfStatistic, boolean isResponse, long inTime, long outTime, boolean isFault) {
        StatisticsHolder statisticsHolder = (StatisticsHolder)this.proxyServicesStatistics.get(keyOfStatistic);
        if (statisticsHolder == null) {
            statisticsHolder = new StatisticsHolder();
            statisticsHolder.setKey(keyOfStatistic);
            statisticsHolder.setStatisticsCategory(1);
            this.proxyServicesStatistics.put(keyOfStatistic, statisticsHolder);
        }
        statisticsHolder.update(isResponse, inTime, outTime, isFault);
    }

    public void reportForSequence(String keyOfStatistic, boolean isResponse, long inTime, long outTime, boolean isFault) {
        StatisticsHolder statisticsHolder = (StatisticsHolder)this.sequenceStatistics.get(keyOfStatistic);
        if (statisticsHolder == null) {
            statisticsHolder = new StatisticsHolder();
            statisticsHolder.setKey(keyOfStatistic);
            statisticsHolder.setStatisticsCategory(0);
            this.sequenceStatistics.put(keyOfStatistic, statisticsHolder);
        }
        statisticsHolder.update(isResponse, inTime, outTime, isFault);
    }

    public Map getSequenceStatistics() {
        return this.sequenceStatistics;
    }

    public Map getProxyServiceStatistics() {
        return this.proxyServicesStatistics;
    }

    public Map getEndPointStatistics() {
        return this.endpointStatistics;
    }

    public void resetSequenceStatistics() {
        this.sequenceStatistics.clear();
    }

    public void resetProxyServiceStatistics() {
        this.proxyServicesStatistics.clear();
    }

    public void resetEndPointStatistics() {
        this.endpointStatistics.clear();
    }
}

