/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.statistics;

public class Statistics {
    private long maxProcessingTime = 0L;
    private long minProcessingTime = -1L;
    private double avgProcessingTime = 0.0;
    private double totalProcessingTime;
    private int count = 0;
    private int faultCount = 0;

    public void update(long inTime, long outTime, boolean isFault) {
        long responseTime;
        if (outTime < 0L || inTime < 0L) {
            return;
        }
        ++this.count;
        if (isFault) {
            ++this.faultCount;
        }
        if (this.maxProcessingTime < (responseTime = outTime - inTime)) {
            this.maxProcessingTime = responseTime;
        }
        if (this.minProcessingTime > responseTime) {
            this.minProcessingTime = responseTime;
        }
        if (this.minProcessingTime == -1L) {
            this.minProcessingTime = responseTime;
        }
        this.totalProcessingTime += (double)responseTime;
        this.avgProcessingTime = this.totalProcessingTime / (double)this.count;
    }

    public long getMaxProcessingTime() {
        return this.maxProcessingTime;
    }

    public double getAvgProcessingTime() {
        return this.avgProcessingTime;
    }

    public long getMinProcessingTime() {
        return this.minProcessingTime;
    }

    public int getFaultCount() {
        return this.faultCount;
    }

    public int getCount() {
        return this.count;
    }
}

