/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.registry.url;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.registry.AbstractRegistry;
import org.apache.synapse.registry.Registry;
import org.apache.synapse.registry.RegistryEntry;
import org.apache.synapse.registry.url.URLRegistryEntry;

public class SimpleURLRegistry
extends AbstractRegistry
implements Registry {
    private static final Log log = LogFactory.getLog(SimpleURLRegistry.class);
    private static final int MAX_KEYS = 200;

    public OMNode lookup(String key) {
        log.info((Object)("==> Repository fetch of resource with key : " + key));
        URLConnection urlc = null;
        try {
            URL url = SynapseConfigUtils.getURLFromPath(this.getRoot() + key);
            if (url == null) {
                return null;
            }
            urlc = url.openConnection();
            urlc.connect();
        }
        catch (IOException e) {
            return null;
        }
        try {
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(urlc.getInputStream());
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            return builder.getDocumentElement();
        }
        catch (MalformedURLException e) {
            this.handleException("Invalid URL reference " + this.getRoot() + key, e);
        }
        catch (FileNotFoundException fnf) {
            return null;
        }
        catch (IOException e) {
            this.handleException("IO Error reading from URL " + this.getRoot() + key, e);
        }
        catch (XMLStreamException e) {
            this.handleException("XML Error reading from URL " + this.getRoot() + key, e);
        }
        return null;
    }

    public RegistryEntry getRegistryEntry(String key) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Perform RegistryEntry lookup for key : " + key));
        }
        try {
            URL url = SynapseConfigUtils.getURLFromPath(this.getRoot() + key);
            if (url == null) {
                return null;
            }
            URLConnection urlc = url.openConnection();
            urlc.setReadTimeout(30000);
            urlc.setRequestProperty("Connection", "Close");
            URLRegistryEntry wre = new URLRegistryEntry();
            wre.setKey(key);
            wre.setName(url.getFile());
            wre.setType(new URI(urlc.getContentType()));
            wre.setDescription("Resource at : " + url.toString());
            wre.setLastModified(urlc.getLastModified());
            wre.setVersion(urlc.getLastModified());
            if (urlc.getExpiration() > 0L) {
                wre.setCachableDuration(urlc.getExpiration() - System.currentTimeMillis());
            } else {
                wre.setCachableDuration(this.getCachableDuration());
            }
            return wre;
        }
        catch (MalformedURLException e) {
            this.handleException("Invalid URL reference " + this.getRoot() + key, e);
        }
        catch (IOException e) {
            this.handleException("IO Error reading from URL " + this.getRoot() + key, e);
        }
        catch (URISyntaxException e) {
            this.handleException("URI Syntax error reading from URL " + this.getRoot() + key, e);
        }
        return null;
    }

    public void addConfigProperty(String name, String value) {
        if (name.equals("root")) {
            try {
                URL url = new URL(value);
                if (url.getProtocol().equals("file") && !value.endsWith("/")) {
                    value = value + "/";
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        super.addConfigProperty(name, value);
    }

    public String getRoot() {
        String root = (String)this.properties.get("root");
        if (root == null) {
            return "";
        }
        return root;
    }

    public long getCachableDuration() {
        String cachableDuration = (String)this.properties.get("cachableDuration");
        return cachableDuration == null ? 1500L : Long.parseLong(cachableDuration);
    }

    public RegistryEntry[] getChildren(RegistryEntry entry) {
        URL url;
        if (entry == null) {
            URLRegistryEntry urlEntry = new URLRegistryEntry();
            urlEntry.setKey("");
            entry = urlEntry;
        }
        if ((url = SynapseConfigUtils.getURLFromPath(this.getRoot() + entry.getKey())) == null) {
            return null;
        }
        if (url.getProtocol().equals("file")) {
            File file = new File(url.getFile());
            if (!file.isDirectory()) {
                return null;
            }
            InputStream inStream = null;
            try {
                inStream = (InputStream)url.getContent();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
                ArrayList<URLRegistryEntry> entryList = new ArrayList<URLRegistryEntry>();
                String key = "";
                while ((key = reader.readLine()) != null) {
                    URLRegistryEntry registryEntry = new URLRegistryEntry();
                    if (entry.getKey().equals("")) {
                        registryEntry.setKey(key);
                    } else if (entry.getKey().endsWith("/")) {
                        registryEntry.setKey(entry.getKey() + key);
                    } else {
                        registryEntry.setKey(entry.getKey() + "/" + key);
                    }
                    entryList.add(registryEntry);
                }
                RegistryEntry[] entries = new RegistryEntry[entryList.size()];
                for (int i = 0; i < entryList.size(); ++i) {
                    entries[i] = (RegistryEntry)entryList.get(i);
                }
                return entries;
            }
            catch (Exception e) {
                throw new SynapseException("Error in reading the URL.");
            }
        }
        throw new SynapseException("Invalid protocol.");
    }

    public RegistryEntry[] getDescendants(RegistryEntry entry) {
        ArrayList list = new ArrayList();
        RegistryEntry[] entries = this.getChildren(entry);
        if (entries != null) {
            for (int i = 0; i < entries.length && list.size() <= 200; ++i) {
                this.fillDescendants(entries[i], list);
            }
        }
        RegistryEntry[] descendants = new RegistryEntry[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            descendants[i] = (RegistryEntry)list.get(i);
        }
        return descendants;
    }

    private void fillDescendants(RegistryEntry parent, ArrayList list) {
        RegistryEntry[] entries = this.getChildren(parent);
        if (entries != null) {
            for (int i = 0; i < entries.length && list.size() <= 200; ++i) {
                this.fillDescendants(entries[i], list);
            }
        } else {
            list.add(parent);
        }
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

