/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.transform;

import java.net.URI;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultNode;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultRole;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;

public class FaultMediator
extends AbstractMediator {
    public static final String WSA_ACTION = "Action";
    public static final int SOAP11 = 1;
    public static final int SOAP12 = 2;
    private int soapVersion;
    private QName faultCodeValue = null;
    private AXIOMXPath faultCodeExpr = null;
    private String faultReasonValue = null;
    private AXIOMXPath faultReasonExpr = null;
    private URI faultNode = null;
    private URI faultRole = null;
    private String faultDetail = null;

    public boolean mediate(MessageContext synCtx) {
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : Fault mediator");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        switch (this.soapVersion) {
            case 1: {
                return this.makeSOAPFault(synCtx, 1, traceOrDebugOn, traceOn);
            }
            case 2: {
                return this.makeSOAPFault(synCtx, 2, traceOrDebugOn, traceOn);
            }
        }
        SOAPEnvelope envelop = synCtx.getEnvelope();
        if (envelop != null) {
            if ("http://www.w3.org/2003/05/soap-envelope".equals(envelop.getNamespace().getNamespaceURI())) {
                this.soapVersion = 2;
                return this.makeSOAPFault(synCtx, 2, traceOrDebugOn, traceOn);
            }
            this.soapVersion = 1;
            return this.makeSOAPFault(synCtx, 1, traceOrDebugOn, traceOn);
        }
        return this.makeSOAPFault(synCtx, 1, traceOrDebugOn, traceOn);
    }

    private boolean makeSOAPFault(MessageContext synCtx, int soapVersion, boolean traceOrDebugOn, boolean traceOn) {
        SOAPHeader soapHeader;
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Creating a SOAP " + (soapVersion == 1 ? "1.1" : "1.2") + " fault");
        }
        SOAPFactory factory = soapVersion == 1 ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
        OMDocument soapFaultDocument = factory.createOMDocument();
        SOAPEnvelope faultEnvelope = factory.getDefaultFaultEnvelope();
        soapFaultDocument.addChild((OMNode)faultEnvelope);
        SOAPFault fault = faultEnvelope.getBody().getFault();
        if (fault == null) {
            fault = factory.createSOAPFault();
        }
        this.setFaultCode(synCtx, factory, fault);
        this.setFaultResaon(synCtx, factory, fault);
        this.setFaultNode(factory, fault);
        this.setFaultRole(factory, fault);
        this.setFaultDetail(factory, fault);
        if (synCtx.getEnvelope() != null && (soapHeader = synCtx.getEnvelope().getHeader()) != null) {
            Iterator iter = soapHeader.examineAllHeaderBlocks();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (o instanceof SOAPHeaderBlock) {
                    SOAPHeaderBlock header = (SOAPHeaderBlock)o;
                    faultEnvelope.getHeader().addChild((OMNode)header);
                    continue;
                }
                if (!(o instanceof OMElement)) continue;
                faultEnvelope.getHeader().addChild((OMNode)((OMElement)o));
            }
        }
        if (traceOrDebugOn) {
            String msg = "Original SOAP Message : " + synCtx.getEnvelope().toString() + "Fault Message created : " + faultEnvelope.toString();
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)msg);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)msg);
            }
        }
        try {
            synCtx.setEnvelope(faultEnvelope);
        }
        catch (AxisFault af) {
            this.handleException("Error replacing current SOAP envelope with the fault envelope", (Exception)((Object)af), synCtx);
        }
        if (synCtx.getFaultTo() != null) {
            synCtx.setTo(synCtx.getFaultTo());
        } else if (synCtx.getReplyTo() != null) {
            synCtx.setTo(synCtx.getReplyTo());
        } else {
            synCtx.setTo(null);
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "End : Fault mediator");
        }
        return true;
    }

    private void setFaultCode(MessageContext synCtx, SOAPFactory factory, SOAPFault fault) {
        QName fault_code = null;
        if (this.faultCodeValue == null && this.faultCodeExpr == null) {
            this.handleException("A valid fault code QName value or expression is required", synCtx);
        } else {
            fault_code = this.faultCodeValue != null ? this.faultCodeValue : QName.valueOf(Axis2MessageContext.getStringValue(this.faultCodeExpr, synCtx));
        }
        SOAPFaultCode code = factory.createSOAPFaultCode();
        switch (this.soapVersion) {
            case 1: {
                code.setText(fault_code);
                break;
            }
            case 2: {
                SOAPFaultValue value = factory.createSOAPFaultValue(code);
                value.setText(fault_code);
            }
        }
        fault.setCode(code);
    }

    private void setFaultResaon(MessageContext synCtx, SOAPFactory factory, SOAPFault fault) {
        String reasonString = null;
        if (this.faultReasonValue == null && this.faultReasonExpr == null) {
            this.handleException("A valid fault reason value or expression is required", synCtx);
        } else {
            reasonString = this.faultReasonValue != null ? this.faultReasonValue : Axis2MessageContext.getStringValue(this.faultReasonExpr, synCtx);
        }
        SOAPFaultReason reason = factory.createSOAPFaultReason();
        switch (this.soapVersion) {
            case 1: {
                reason.setText(reasonString);
                break;
            }
            case 2: {
                SOAPFaultText text = factory.createSOAPFaultText();
                text.setText(reasonString);
                reason.addSOAPText(text);
            }
        }
        fault.setReason(reason);
    }

    private void setFaultNode(SOAPFactory factory, SOAPFault fault) {
        if (this.faultNode != null) {
            SOAPFaultNode soapfaultNode = factory.createSOAPFaultNode();
            soapfaultNode.setNodeValue(this.faultNode.toString());
            fault.setNode(soapfaultNode);
        }
    }

    private void setFaultRole(SOAPFactory factory, SOAPFault fault) {
        if (this.faultRole != null) {
            SOAPFaultRole soapFaultRole = factory.createSOAPFaultRole();
            soapFaultRole.setRoleValue(this.faultRole.toString());
            fault.setRole(soapFaultRole);
        }
    }

    private void setFaultDetail(SOAPFactory factory, SOAPFault fault) {
        if (this.faultDetail != null) {
            SOAPFaultDetail soapFaultDetail = factory.createSOAPFaultDetail();
            soapFaultDetail.setText(this.faultDetail);
            fault.setDetail(soapFaultDetail);
        } else if (fault.getDetail() != null) {
            fault.getDetail().detach();
        }
    }

    public int getSoapVersion() {
        return this.soapVersion;
    }

    public void setSoapVersion(int soapVersion) {
        this.soapVersion = soapVersion;
    }

    public QName getFaultCodeValue() {
        return this.faultCodeValue;
    }

    public void setFaultCodeValue(QName faultCodeValue) {
        if (this.soapVersion == 1) {
            this.faultCodeValue = faultCodeValue;
        } else if ("http://www.w3.org/2003/05/soap-envelope".equals(faultCodeValue.getNamespaceURI()) && ("DataEncodingUnknown".equals(faultCodeValue.getLocalPart()) || "MustUnderstand".equals(faultCodeValue.getLocalPart()) || "Receiver".equals(faultCodeValue.getLocalPart()) || "Sender".equals(faultCodeValue.getLocalPart()) || "VersionMismatch".equals(faultCodeValue.getLocalPart()))) {
            this.faultCodeValue = faultCodeValue;
        } else {
            String msg = "Invalid Fault code value for a SOAP 1.2 fault : " + faultCodeValue;
            this.log.error((Object)msg);
            throw new SynapseException(msg);
        }
    }

    public AXIOMXPath getFaultCodeExpr() {
        return this.faultCodeExpr;
    }

    public void setFaultCodeExpr(AXIOMXPath faultCodeExpr) {
        this.faultCodeExpr = faultCodeExpr;
    }

    public String getFaultReasonValue() {
        return this.faultReasonValue;
    }

    public void setFaultReasonValue(String faultReasonValue) {
        this.faultReasonValue = faultReasonValue;
    }

    public AXIOMXPath getFaultReasonExpr() {
        return this.faultReasonExpr;
    }

    public void setFaultReasonExpr(AXIOMXPath faultReasonExpr) {
        this.faultReasonExpr = faultReasonExpr;
    }

    public URI getFaultNode() {
        return this.faultNode;
    }

    public void setFaultNode(URI faultNode) {
        if (this.soapVersion == 1) {
            String msg = "A fault node does not apply to a SOAP 1.1 fault";
            this.log.error((Object)msg);
            throw new SynapseException(msg);
        }
        this.faultNode = faultNode;
    }

    public URI getFaultRole() {
        return this.faultRole;
    }

    public void setFaultRole(URI faultRole) {
        this.faultRole = faultRole;
    }

    public String getFaultDetail() {
        return this.faultDetail;
    }

    public void setFaultDetail(String faultDetail) {
        this.faultDetail = faultDetail;
    }
}

