/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.db;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.xml.AbstractDBMediatorFactory;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.db.DBLookupMediator;
import org.apache.synapse.mediators.db.Statement;

public abstract class AbstractDBMediator
extends AbstractMediator
implements ManagedLifecycle {
    protected Map dataSourceProps = new HashMap();
    private DataSource dataSource = null;
    List statementList = new ArrayList();

    public void init(SynapseEnvironment se) {
    }

    public void destroy() {
        if (this.getDataSource() instanceof BasicDataSource) {
            try {
                ((BasicDataSource)this.getDataSource()).close();
                this.log.info((Object)("Successfully shut down DB connection pool for URL : " + this.getDSName()));
            }
            catch (SQLException e) {
                this.log.warn((Object)("Error shutting down DB connection pool for URL : " + this.getDSName()));
            }
        }
    }

    public boolean mediate(MessageContext synCtx) {
        String name = this instanceof DBLookupMediator ? "DBLookup" : "DBReport";
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : " + name + " mediator");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        Iterator iter = this.statementList.iterator();
        while (iter.hasNext()) {
            this.processStatement((Statement)iter.next(), synCtx);
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "End : " + name + " mediator");
        }
        return true;
    }

    protected abstract void processStatement(Statement var1, MessageContext var2);

    protected String getDSName() {
        return (String)this.dataSourceProps.get(AbstractDBMediatorFactory.URL_Q);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void addDataSourceProperty(QName name, String value) {
        this.dataSourceProps.put(name, value);
    }

    public void addDataSourceProperty(String name, String value) {
        this.dataSourceProps.put(name, value);
    }

    public Map getDataSourceProps() {
        return this.dataSourceProps;
    }

    public void addStatement(Statement stmnt) {
        this.statementList.add(stmnt);
    }

    public List getStatementList() {
        return this.statementList;
    }

    protected PreparedStatement getPreparedStatement(Statement stmnt, MessageContext msgCtx) throws SQLException {
        boolean traceOn = this.isTraceOn(msgCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        Log serviceLog = msgCtx.getServiceLog();
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Getting a connection from DataSource " + this.getDSName() + " and preparing statement : " + stmnt.getRawStatement());
        }
        Connection con = this.getDataSource().getConnection();
        PreparedStatement ps = con.prepareStatement(stmnt.getRawStatement());
        List params = stmnt.getParameters();
        int column = 1;
        block15: for (Statement.Parameter param : params) {
            String value;
            String string = value = param.getPropertyName() != null ? param.getPropertyName() : Axis2MessageContext.getStringValue(param.getXpath(), msgCtx);
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Setting as parameter : " + column + " value : " + value + " as JDBC Type : " + param.getType() + "(see java.sql.Types for valid types)");
            }
            switch (param.getType()) {
                case -1: 
                case 1: 
                case 12: {
                    ps.setString(column++, value);
                    continue block15;
                }
                case 2: 
                case 3: {
                    ps.setBigDecimal(column++, new BigDecimal(value));
                    continue block15;
                }
                case -7: {
                    ps.setBoolean(column++, Boolean.parseBoolean(value));
                    continue block15;
                }
                case -6: {
                    ps.setByte(column++, Byte.parseByte(value));
                    continue block15;
                }
                case 5: {
                    ps.setShort(column++, Short.parseShort(value));
                    continue block15;
                }
                case 4: {
                    ps.setInt(column++, Integer.parseInt(value));
                    continue block15;
                }
                case -5: {
                    ps.setLong(column++, Long.parseLong(value));
                    continue block15;
                }
                case 7: {
                    ps.setFloat(column++, Float.parseFloat(value));
                    continue block15;
                }
                case 6: {
                    ps.setDouble(column++, Double.parseDouble(value));
                    continue block15;
                }
                case 8: {
                    ps.setDouble(column++, Double.parseDouble(value));
                    continue block15;
                }
                case 91: {
                    ps.setDate(column++, Date.valueOf(value));
                    continue block15;
                }
                case 92: {
                    ps.setTime(column++, Time.valueOf(value));
                    continue block15;
                }
                case 93: {
                    ps.setTimestamp(column++, Timestamp.valueOf(value));
                    continue block15;
                }
            }
            String msg = "Trying to set an un-supported JDBC Type : " + param.getType() + " against column : " + column + " and statement : " + stmnt.getRawStatement() + " used by a DB mediator against DataSource : " + this.getDSName() + " (see java.sql.Types for valid type values)";
            this.handleException(msg, msgCtx);
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Successfully prepared statement : " + stmnt.getRawStatement() + " against DataSource : " + this.getDSName());
        }
        return ps;
    }
}

