/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.util.MessageHelper;
import org.jaxen.JaxenException;

public class CalloutMediator
extends AbstractMediator
implements ManagedLifecycle {
    private ServiceClient sc = null;
    private String serviceURL = null;
    private String action = null;
    private String requestKey = null;
    private String requestXPathString = null;
    private AXIOMXPath requestXPath = null;
    private String targetXPathString = null;
    private AXIOMXPath targetXPath = null;
    private String targetKey = null;

    public boolean mediate(MessageContext synCtx) {
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : Callout mediator");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        try {
            Options options = new Options();
            options.setTo(new EndpointReference(this.serviceURL));
            if (this.action != null) {
                options.setAction(this.action);
            }
            options.setProperty("disableAddressingForOutMessages", (Object)Boolean.TRUE);
            this.sc.setOptions(options);
            OMElement request = this.getRequestPayload(synCtx);
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "About to invoke service : " + this.serviceURL + (this.action != null ? " with action : " + this.action : ""));
                if (traceOn && trace.isTraceEnabled()) {
                    trace.trace((Object)("Request message payload : " + request));
                }
            }
            OMElement result = this.sc.sendReceive(request);
            if (traceOrDebugOn && traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Response payload received : " + result));
            }
            if (result != null) {
                if (this.targetXPath != null) {
                    Object o = this.targetXPath.evaluate((Object)synCtx.getEnvelope());
                    if (o != null && o instanceof OMElement) {
                        OMElement tgtNode = (OMElement)o;
                        tgtNode.insertSiblingAfter((OMNode)result);
                        tgtNode.detach();
                    } else if (o != null && o instanceof List && !((List)o).isEmpty()) {
                        OMElement tgtNode = (OMElement)((List)o).get(0);
                        tgtNode.insertSiblingAfter((OMNode)result);
                        tgtNode.detach();
                    } else {
                        this.handleException("Evaluation of target XPath expression : " + this.targetXPathString + " did not yeild an OMNode", synCtx);
                    }
                }
                if (this.targetKey != null) {
                    synCtx.setProperty(this.targetKey, result);
                }
            } else if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Service returned a null response");
            }
        }
        catch (Exception e) {
            this.handleException("Error invoking service : " + this.serviceURL + (this.action != null ? " with action : " + this.action : ""), e, synCtx);
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "End : Callout mediator");
        }
        return true;
    }

    private OMElement getRequestPayload(MessageContext synCtx) throws AxisFault {
        if (this.requestKey != null) {
            Object request = synCtx.getProperty(this.requestKey);
            if (request == null) {
                request = synCtx.getEntry(this.requestKey);
            }
            if (request != null && request instanceof OMElement) {
                return (OMElement)request;
            }
            this.handleException("The property : " + this.requestKey + " is not an OMElement", synCtx);
        } else if (this.requestXPath != null) {
            try {
                Object o = null;
                o = this.requestXPath.evaluate((Object)MessageHelper.cloneMessageContext(synCtx).getEnvelope());
                if (o instanceof OMElement) {
                    return (OMElement)o;
                }
                if (o instanceof List && !((List)o).isEmpty()) {
                    return (OMElement)((List)o).get(0);
                }
                this.handleException("The evaluation of the XPath expression : " + this.requestXPathString + " did not result in an OMElement", synCtx);
            }
            catch (JaxenException e) {
                this.handleException("Error evaluating XPath expression : " + this.requestXPathString, (Exception)((Object)e), synCtx);
            }
        }
        return null;
    }

    public void init(SynapseEnvironment synEnv) {
        try {
            ConfigurationContext cfgCtx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)"./samples/axis2Client/client_repo", (String)"./samples/axis2Client/client_repo/conf/axis2.xml");
            this.sc = new ServiceClient(cfgCtx, null);
        }
        catch (AxisFault e) {
            String msg = "Error initializing callout mediator : " + e.getMessage();
            this.log.error((Object)msg, (Throwable)e);
            throw new SynapseException(msg, e);
        }
    }

    public void destroy() {
        try {
            this.sc.cleanup();
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public void setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getRequestKey() {
        return this.requestKey;
    }

    public void setRequestKey(String requestKey) {
        this.requestKey = requestKey;
    }

    public String getRequestXPathString() {
        return this.requestXPathString;
    }

    public void setRequestXPathString(String requestXPathString) throws JaxenException {
        this.requestXPathString = requestXPathString;
        this.requestXPath = new AXIOMXPath(requestXPathString);
    }

    public String getTargetXPathString() {
        return this.targetXPathString;
    }

    public void setTargetXPathString(String targetXPathString) throws JaxenException {
        this.targetXPathString = targetXPathString;
        this.targetXPath = new AXIOMXPath(targetXPathString);
    }

    public String getTargetKey() {
        return this.targetKey;
    }

    public void setTargetKey(String targetKey) {
        this.targetKey = targetKey;
    }

    public AXIOMXPath getRequestXPath() {
        return this.requestXPath;
    }

    public AXIOMXPath getTargetXPath() {
        return this.targetXPath;
    }
}

