/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.context.OperationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;
import org.apache.synapse.endpoints.dispatch.Dispatcher;

public class SALoadbalanceEndpoint
implements Endpoint {
    private static final Log log = LogFactory.getLog(SALoadbalanceEndpoint.class);
    private static final String FIRST_MESSAGE_IN_SESSION = "first_message_in_session";
    private String name = null;
    private List endpoints = null;
    private LoadbalanceAlgorithm algorithm = null;
    private volatile boolean active = true;
    private Endpoint parentEndpoint = null;
    private Dispatcher dispatcher = null;

    public void send(MessageContext synMessageContext) {
        Endpoint endpoint = null;
        endpoint = this.dispatcher.getEndpoint(synMessageContext);
        if (endpoint == null) {
            endpoint = this.algorithm.getNextEndpoint(synMessageContext);
            if (this.dispatcher.isServerInitiatedSession()) {
                Axis2MessageContext axis2MsgCtx = (Axis2MessageContext)synMessageContext;
                OperationContext opCtx = axis2MsgCtx.getAxis2MessageContext().getOperationContext();
                Object o = opCtx.getProperty("endpointList");
                if (o != null) {
                    List endpointList = (List)o;
                    endpointList.add(this);
                    if (!(endpoint instanceof SALoadbalanceEndpoint)) {
                        endpointList.add(endpoint);
                    }
                } else {
                    ArrayList<Endpoint> endpointList = new ArrayList<Endpoint>();
                    endpointList.add(this);
                    if (!(endpoint instanceof SALoadbalanceEndpoint)) {
                        endpointList.add(endpoint);
                    }
                    opCtx.setProperty("endpointList", endpointList);
                }
            } else {
                this.dispatcher.updateSession(synMessageContext, endpoint);
            }
            synMessageContext.getEnvelope().build();
            synMessageContext.setProperty(FIRST_MESSAGE_IN_SESSION, Boolean.TRUE);
        }
        if (endpoint != null) {
            if (endpoint.isActive(synMessageContext)) {
                endpoint.send(synMessageContext);
            } else {
                this.informFailure(synMessageContext);
            }
        } else {
            this.setActive(false, synMessageContext);
            this.informFailure(synMessageContext);
        }
    }

    public void updateSession(MessageContext responseMsgCtx, List endpointList) {
        Endpoint endpoint = (Endpoint)endpointList.remove(0);
        this.dispatcher.updateSession(responseMsgCtx, endpoint);
        if (endpoint instanceof SALoadbalanceEndpoint) {
            ((SALoadbalanceEndpoint)endpoint).updateSession(responseMsgCtx, endpointList);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public LoadbalanceAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(LoadbalanceAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public boolean isActive(MessageContext synMessageContext) {
        return this.active;
    }

    public void setActive(boolean active, MessageContext synMessageContext) {
        this.active = active;
    }

    public List getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List endpoints) {
        this.endpoints = endpoints;
    }

    public void setParentEndpoint(Endpoint parentEndpoint) {
        this.parentEndpoint = parentEndpoint;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void onChildEndpointFail(Endpoint endpoint, MessageContext synMessageContext) {
        Object o = synMessageContext.getProperty(FIRST_MESSAGE_IN_SESSION);
        if (o != null && Boolean.TRUE.equals(o)) {
            this.dispatcher.unbind(synMessageContext);
            this.send(synMessageContext);
        } else {
            this.informFailure(synMessageContext);
        }
    }

    private void informFailure(MessageContext synMessageContext) {
        if (this.parentEndpoint != null) {
            this.parentEndpoint.onChildEndpointFail(this, synMessageContext);
        } else {
            Object o = synMessageContext.getFaultStack().pop();
            if (o != null) {
                ((FaultHandler)o).handleFault(synMessageContext);
            }
        }
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

