/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.util.List;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;

public class LoadbalanceEndpoint
implements Endpoint {
    private String name = null;
    private List endpoints = null;
    private LoadbalanceAlgorithm algorithm = null;
    private volatile boolean active = true;
    private boolean failover = true;
    private Endpoint parentEndpoint = null;

    public void send(MessageContext synMessageContext) {
        Endpoint endpoint = this.algorithm.getNextEndpoint(synMessageContext);
        if (endpoint != null) {
            if (this.failover) {
                synMessageContext.getEnvelope().build();
            }
            endpoint.send(synMessageContext);
        } else {
            this.setActive(false, synMessageContext);
            if (this.parentEndpoint != null) {
                this.parentEndpoint.onChildEndpointFail(this, synMessageContext);
            } else {
                Object o = synMessageContext.getFaultStack().pop();
                if (o != null) {
                    ((FaultHandler)o).handleFault(synMessageContext);
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public LoadbalanceAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(LoadbalanceAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public boolean isActive(MessageContext synMessageContext) {
        if (!this.active && this.endpoints != null) {
            for (int i = 0; i < this.endpoints.size(); ++i) {
                Endpoint endpoint = (Endpoint)this.endpoints.get(i);
                if (!endpoint.isActive(synMessageContext)) continue;
                this.active = true;
            }
        }
        return this.active;
    }

    public void setActive(boolean active, MessageContext synMessageContext) {
        this.active = active;
    }

    public boolean isFailover() {
        return this.failover;
    }

    public void setFailover(boolean failover) {
        this.failover = failover;
    }

    public List getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List endpoints) {
        this.endpoints = endpoints;
    }

    public void setParentEndpoint(Endpoint parentEndpoint) {
        this.parentEndpoint = parentEndpoint;
    }

    public void onChildEndpointFail(Endpoint endpoint, MessageContext synMessageContext) {
        if (this.failover) {
            this.send(synMessageContext);
        } else {
            Object o = synMessageContext.getFaultStack().pop();
            if (o != null) {
                ((FaultHandler)o).handleFault(synMessageContext);
            }
        }
    }
}

