/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.WSDLEndpoint;
import org.apache.synapse.endpoints.utils.EndpointDefinition;

public class IndirectEndpoint
implements Endpoint {
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    private static final Log log = LogFactory.getLog(IndirectEndpoint.class);
    private String name = null;
    private String key = null;
    private boolean active = true;
    private Endpoint parentEndpoint = null;
    private MessageContext currentMsgCtx = null;

    public void send(MessageContext synMessageContext) {
        Endpoint endpoint = synMessageContext.getEndpoint(this.key);
        if (endpoint == null) {
            this.handleException("Reference to non-existent endpoint for key : " + this.key);
        }
        if (endpoint.isActive(synMessageContext)) {
            endpoint.send(synMessageContext);
        } else if (this.parentEndpoint != null) {
            this.auditWarn("Endpoint : " + endpoint.getName() + " is currently inactive" + " - invoking parent endpoint", synMessageContext);
            this.parentEndpoint.onChildEndpointFail(this, synMessageContext);
        } else {
            this.auditWarn("Endpoint : " + endpoint.getName() + " is currently inactive" + " - invoking fault handler / assuming failure", synMessageContext);
            Object o = synMessageContext.getFaultStack().pop();
            if (o != null) {
                ((FaultHandler)o).handleFault(synMessageContext);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean isActive(MessageContext synMessageContext) {
        Endpoint endpoint = synMessageContext.getEndpoint(this.key);
        if (endpoint == null) {
            this.handleException("Reference to non-existent endpoint for key : " + this.key);
        }
        return endpoint.isActive(synMessageContext);
    }

    public void setActive(boolean active, MessageContext synMessageContext) {
        Endpoint endpoint = synMessageContext.getEndpoint(this.key);
        if (endpoint == null) {
            this.handleException("Reference to non-existent endpoint for key : " + this.key);
        }
        endpoint.setActive(active, synMessageContext);
    }

    public void setParentEndpoint(Endpoint parentEndpoint) {
        this.parentEndpoint = parentEndpoint;
    }

    public void onChildEndpointFail(Endpoint endpoint, MessageContext synMessageContext) {
        if (this.parentEndpoint != null) {
            this.parentEndpoint.onChildEndpointFail(this, synMessageContext);
        } else {
            Object o = synMessageContext.getFaultStack().pop();
            if (o != null) {
                ((FaultHandler)o).handleFault(synMessageContext);
            }
        }
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    protected void auditWarn(String msg, MessageContext msgContext) {
        log.warn((Object)msg);
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().warn((Object)msg);
        }
        if (this.shouldTrace(msgContext)) {
            trace.warn((Object)msg);
        }
    }

    public boolean shouldTrace(MessageContext synCtx) {
        Endpoint endpoint = synCtx.getEndpoint(this.key);
        EndpointDefinition endptDefn = null;
        if (endpoint instanceof AddressEndpoint) {
            AddressEndpoint addEndpt = (AddressEndpoint)endpoint;
            endptDefn = addEndpt.getEndpoint();
        } else if (endpoint instanceof WSDLEndpoint) {
            WSDLEndpoint wsdlEndpt = (WSDLEndpoint)endpoint;
            endptDefn = wsdlEndpt.getEndpoint();
        }
        if (endptDefn != null) {
            return endptDefn.getTraceState() == 1 || endptDefn.getTraceState() == 2 && synCtx.getTracingState() == 1;
        }
        return false;
    }
}

