/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.util.concurrent.ExecutorService;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2Sender;
import org.apache.synapse.endpoints.utils.EndpointDefinition;
import org.apache.synapse.mediators.MediatorWorker;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.statistics.StatisticsCollector;
import org.apache.synapse.statistics.StatisticsUtils;
import org.apache.synapse.util.UUIDGenerator;
import org.apache.synapse.util.concurrent.SynapseThreadPool;

public class Axis2SynapseEnvironment
implements SynapseEnvironment {
    private static final Log log = LogFactory.getLog(Axis2SynapseEnvironment.class);
    private SynapseConfiguration synapseConfig;
    private ConfigurationContext configContext;
    private ExecutorService executorService;
    private boolean initialized = false;
    private StatisticsCollector statisticsCollector;

    public Axis2SynapseEnvironment(SynapseConfiguration synCfg) {
        int coreThreads = 20;
        int maxThreads = 100;
        long keepAlive = 5L;
        int qlength = 10;
        try {
            qlength = Integer.parseInt(synCfg.getProperty("synapse.threads.qlen"));
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            coreThreads = Integer.parseInt(synCfg.getProperty("synapse.threads.core"));
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            maxThreads = Integer.parseInt(synCfg.getProperty("synapse.threads.max"));
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            keepAlive = Long.parseLong(synCfg.getProperty("synapse.threads.keepalive"));
        }
        catch (Exception ignore) {
            // empty catch block
        }
        this.executorService = new SynapseThreadPool(coreThreads, maxThreads, keepAlive, qlength, synCfg.getProperty("synapse.threads.group", "synapse-thread-group"), synCfg.getProperty("synapse.threads.idprefix", "SynapseWorker"));
    }

    public Axis2SynapseEnvironment(ConfigurationContext cfgCtx, SynapseConfiguration synapseConfig) {
        this(synapseConfig);
        this.configContext = cfgCtx;
        this.synapseConfig = synapseConfig;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean injectMessage(MessageContext synCtx) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Injecting MessageContext");
        }
        synCtx.setEnvironment(this);
        if (synCtx.isResponse()) {
            StatisticsUtils.processEndPointStatistics(synCtx);
            StatisticsUtils.processProxyServiceStatistics(synCtx);
            StatisticsUtils.processSequenceStatistics(synCtx);
        }
        if (synCtx.getProperty("proxy.name") == null) {
            if (!log.isDebugEnabled()) return synCtx.getMainSequence().mediate(synCtx);
            log.debug((Object)"Using Main Sequence for injected message");
            return synCtx.getMainSequence().mediate(synCtx);
        }
        if (synCtx.getConfiguration().getProxyService((String)synCtx.getProperty("proxy.name")).getTargetOutSequence() != null) {
            String sequenceName = synCtx.getConfiguration().getProxyService((String)synCtx.getProperty("proxy.name")).getTargetOutSequence();
            Mediator outSequence = synCtx.getSequence(sequenceName);
            if (outSequence == null) {
                log.error((Object)("Unable to find the out-sequence specified by the name " + sequenceName));
                throw new SynapseException("Unable to find the out-sequence specified by the name " + sequenceName);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using the sequence named " + sequenceName + " for the outgoing message mediation of the proxy service " + synCtx.getProperty("proxy.name")));
            }
            outSequence.mediate(synCtx);
            return true;
        }
        if (synCtx.getConfiguration().getProxyService((String)synCtx.getProperty("proxy.name")).getTargetInLineOutSequence() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using the anonymous out-sequence specified in the proxy service " + synCtx.getProperty("proxy.name") + " for outgoing message mediation"));
            }
            synCtx.getConfiguration().getProxyService((String)synCtx.getProperty("proxy.name")).getTargetInLineOutSequence().mediate(synCtx);
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Proxy service " + synCtx.getProperty("proxy.name") + " does not specifies an out-sequence - sending the response back"));
        }
        Axis2Sender.sendBack(synCtx);
        return true;
    }

    public void injectAsync(MessageContext synCtx, SequenceMediator seq) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Injecting MessageContext for asynchronous mediation using the : " + (seq.getName() == null ? "Anonymous" : seq.getName()) + " Sequence"));
        }
        synCtx.setEnvironment(this);
        if (synCtx.isResponse()) {
            StatisticsUtils.processEndPointStatistics(synCtx);
            StatisticsUtils.processProxyServiceStatistics(synCtx);
            StatisticsUtils.processSequenceStatistics(synCtx);
        }
        this.executorService.execute(new MediatorWorker(seq, synCtx));
    }

    public void send(EndpointDefinition endpoint, MessageContext synCtx) {
        if (synCtx.isResponse()) {
            if (endpoint != null) {
                StatisticsUtils.processEndPointStatistics(synCtx);
                StatisticsUtils.processProxyServiceStatistics(synCtx);
                StatisticsUtils.processAllSequenceStatistics(synCtx);
                Axis2Sender.sendOn(endpoint, synCtx);
            } else {
                Axis2Sender.sendBack(synCtx);
            }
        } else {
            Axis2Sender.sendOn(endpoint, synCtx);
        }
    }

    public MessageContext createMessageContext() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating Message Context");
        }
        org.apache.axis2.context.MessageContext axis2MC = new org.apache.axis2.context.MessageContext();
        axis2MC.setConfigurationContext(this.configContext);
        ServiceContext svcCtx = new ServiceContext();
        OperationContext opCtx = new OperationContext((AxisOperation)new InOutAxisOperation(), svcCtx);
        axis2MC.setServiceContext(svcCtx);
        axis2MC.setOperationContext(opCtx);
        Axis2MessageContext mc = new Axis2MessageContext(axis2MC, this.synapseConfig, this);
        mc.setMessageID(UUIDGenerator.getUUID());
        try {
            mc.setEnvelope(OMAbstractFactory.getSOAP12Factory().createSOAPEnvelope());
            mc.getEnvelope().addChild((OMNode)OMAbstractFactory.getSOAP12Factory().createSOAPBody());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mc;
    }

    public StatisticsCollector getStatisticsCollector() {
        return this.statisticsCollector;
    }

    public void setStatisticsCollector(StatisticsCollector collector) {
        this.statisticsCollector = collector;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean state) {
        this.initialized = state;
    }
}

