/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.axis2.Axis2FlexibleMEPClient;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.utils.EndpointDefinition;
import org.apache.synapse.statistics.StatisticsUtils;
import org.apache.synapse.util.UUIDGenerator;

public class Axis2Sender {
    private static final Log log = LogFactory.getLog(Axis2Sender.class);

    public static void sendOn(EndpointDefinition endpoint, MessageContext synapseInMessageContext) {
        try {
            Axis2FlexibleMEPClient.send(endpoint, synapseInMessageContext);
        }
        catch (Exception e) {
            Axis2Sender.handleException("Unexpected error during sending message out", e);
        }
    }

    public static void sendBack(MessageContext smc) {
        org.apache.axis2.context.MessageContext messageContext = ((Axis2MessageContext)smc).getAxis2MessageContext();
        if (messageContext.isPropertyTrue("SC_ACCEPTED") && messageContext.getTransportOut() != null && !messageContext.getTransportOut().getName().startsWith("http")) {
            return;
        }
        AxisEngine ae = new AxisEngine(messageContext.getConfigurationContext());
        try {
            messageContext.setProperty("synapse.isresponse", (Object)Boolean.TRUE);
            if (smc.isResponse()) {
                StatisticsUtils.processEndPointStatistics(smc);
                StatisticsUtils.processProxyServiceStatistics(smc);
                StatisticsUtils.processAllSequenceStatistics(smc);
            }
            Axis2FlexibleMEPClient.removeAddressingHeaders(messageContext);
            messageContext.setMessageID(UUIDGenerator.getUUID());
            if (messageContext.isEngaged("rampart") && messageContext.getEnvelope().getHeader() == null) {
                SOAPFactory fac = messageContext.isSOAP11() ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
                fac.createSOAPHeader(messageContext.getEnvelope());
            }
            AxisEngine.send((org.apache.axis2.context.MessageContext)messageContext);
        }
        catch (AxisFault e) {
            Axis2Sender.handleException("Unexpected error sending message back", (Exception)((Object)e));
        }
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

