/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.OMElementUtils;
import org.apache.synapse.mediators.builtin.PropertyMediator;
import org.jaxen.JaxenException;

public class PropertyMediatorFactory
extends AbstractMediatorFactory {
    private static final QName ATT_SCOPE = new QName("scope");
    private static final QName ATT_ACTION = new QName("action");

    public Mediator createMediator(OMElement elem) {
        PropertyMediator propMediator = new PropertyMediator();
        OMAttribute name = elem.getAttribute(ATT_NAME);
        OMAttribute value = elem.getAttribute(ATT_VALUE);
        OMAttribute expression = elem.getAttribute(ATT_EXPRN);
        OMAttribute scope = elem.getAttribute(ATT_SCOPE);
        OMAttribute action = elem.getAttribute(ATT_ACTION);
        if (name == null) {
            String msg = "The 'name' attribute is required for the configuration of a property mediator";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        if (!(value != null || expression != null || action != null && "remove".equals(action.getAttributeValue()))) {
            String msg = "Either an 'value' or 'expression' attribute is required for a property mediator when action is SET";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        propMediator.setName(name.getAttributeValue());
        if (value != null) {
            propMediator.setValue(value.getAttributeValue());
        } else if (expression != null) {
            try {
                AXIOMXPath xp = new AXIOMXPath(expression.getAttributeValue());
                OMElementUtils.addNameSpaces(xp, elem, log);
                propMediator.setExpression(xp);
            }
            catch (JaxenException e) {
                String msg = "Invalid XPath expression for attribute 'expression' : " + expression.getAttributeValue();
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
        }
        if (scope != null) {
            String valueStr = scope.getAttributeValue();
            if (!("axis2".equals(valueStr) || "transport".equals(valueStr) || "default".equals(valueStr) || "axis2-client".equals(valueStr))) {
                String msg = "Only 'axis2' or 'transport' or 'axis2-client' values are allowed for attribute scope for a property mediator, Unsupported scope " + valueStr;
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            propMediator.setScope(valueStr);
        }
        this.processTraceState(propMediator, elem);
        if (action != null && "remove".equals(action.getAttributeValue())) {
            propMediator.setAction(1);
        }
        return propMediator;
    }

    public QName getTagQName() {
        return PROP_Q;
    }
}

