/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.mediators.builtin.CalloutMediator;

public class CalloutMediatorSerializer
extends AbstractMediatorSerializer {
    public OMElement serializeMediator(OMElement parent, Mediator m) {
        if (!(m instanceof CalloutMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        CalloutMediator mediator = (CalloutMediator)m;
        OMElement callout = fac.createOMElement("callout", synNS);
        CalloutMediatorSerializer.saveTracingState(callout, mediator);
        callout.addAttribute(fac.createOMAttribute("serviceURL", nullNS, mediator.getServiceURL()));
        if (mediator.getAction() != null) {
            callout.addAttribute(fac.createOMAttribute("action", nullNS, mediator.getAction()));
        }
        OMElement source = fac.createOMElement("source", synNS, (OMContainer)callout);
        if (mediator.getRequestXPathString() != null) {
            source.addAttribute(fac.createOMAttribute("xpath", nullNS, mediator.getRequestXPathString()));
            this.serializeNamespaces(source, mediator.getRequestXPath());
        } else if (mediator.getRequestKey() != null) {
            source.addAttribute(fac.createOMAttribute("key", nullNS, mediator.getRequestKey()));
        }
        OMElement target = fac.createOMElement("target", synNS, (OMContainer)callout);
        if (mediator.getTargetXPathString() != null) {
            target.addAttribute(fac.createOMAttribute("xpath", nullNS, mediator.getTargetXPathString()));
            this.serializeNamespaces(target, mediator.getTargetXPath());
        } else if (mediator.getTargetKey() != null) {
            target.addAttribute(fac.createOMAttribute("key", nullNS, mediator.getTargetKey()));
        }
        if (parent != null) {
            parent.addChild((OMNode)callout);
        }
        return callout;
    }

    public String getMediatorClassName() {
        return CalloutMediator.class.getName();
    }
}

