/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.xquery;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.javax.xml.xquery.XQConnection;
import net.sf.saxon.javax.xml.xquery.XQDataSource;
import net.sf.saxon.javax.xml.xquery.XQDynamicContext;
import net.sf.saxon.javax.xml.xquery.XQException;
import net.sf.saxon.javax.xml.xquery.XQItem;
import net.sf.saxon.javax.xml.xquery.XQItemType;
import net.sf.saxon.javax.xml.xquery.XQPreparedExpression;
import net.sf.saxon.javax.xml.xquery.XQResultSequence;
import net.sf.saxon.xqj.SaxonXQDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.MediatorProperty;
import org.apache.synapse.mediators.xquery.MediatorVariable;
import org.jaxen.JaxenException;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class XQueryMediator
extends AbstractMediator {
    private List dataSourceProperties = new ArrayList();
    private String queryKey;
    private String querySource;
    public static final String DEFAULT_XPATH = "s11:Body/child::*[position()=1] | s12:Body/child::*[position()=1]";
    private AXIOMXPath target = null;
    private List variables = new ArrayList();
    private final Object resourceLock = new Object();
    private boolean useDOMSource = false;
    private XQDataSource cachedXQDataSource = null;
    private XQConnection cachedConnection = null;
    private XQPreparedExpression cachedPreparedExpression = null;

    public XQueryMediator() {
        try {
            this.target = new AXIOMXPath(DEFAULT_XPATH);
            this.target.addNamespace("s11", "http://schemas.xmlsoap.org/soap/envelope/");
            this.target.addNamespace("s12", "http://www.w3.org/2003/05/soap-envelope");
        }
        catch (JaxenException e) {
            this.handleException("Error creating target XPath expression", (Exception)((Object)e));
        }
    }

    public boolean mediate(MessageContext synCtx) {
        try {
            boolean traceOn = this.isTraceOn(synCtx);
            boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Start : XQuery mediator");
                if (traceOn && trace.isTraceEnabled()) {
                    trace.trace((Object)("Message : " + synCtx.getEnvelope()));
                }
                this.traceOrDebug(traceOn, "Performing XQuery using query resource with key : " + this.queryKey);
            }
            this.performQuery(synCtx, traceOrDebugOn, traceOn);
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "End : XQuery mediator");
            }
            return true;
        }
        catch (Exception e) {
            this.handleException("Unable to execute the query " + this.querySource, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performQuery(MessageContext synCtx, boolean traceOrDebugOn, boolean traceOn) {
        boolean reLoad = false;
        boolean needBind = false;
        Entry dp = synCtx.getConfiguration().getEntryDefinition(this.queryKey);
        if (dp != null && dp.isDynamic() && (!dp.isCached() || dp.isExpired())) {
            reLoad = true;
        }
        try {
            XQResultSequence resultSequence;
            Object object = this.resourceLock;
            synchronized (object) {
                int i;
                if (this.cachedXQDataSource == null) {
                    this.cachedXQDataSource = new SaxonXQDataSource();
                    if (this.dataSourceProperties != null && !this.dataSourceProperties.isEmpty()) {
                        if (traceOrDebugOn) {
                            this.traceOrDebug(traceOn, "Setting up properties to the XQDataSource");
                        }
                        for (i = 0; i < this.dataSourceProperties.size(); ++i) {
                            MediatorProperty prop = (MediatorProperty)this.dataSourceProperties.get(i);
                            if (prop == null) continue;
                            this.cachedXQDataSource.setProperty(prop.getName(), prop.getValue());
                        }
                    }
                }
                if (this.cachedConnection == null || this.cachedConnection != null && this.cachedConnection.isClosed()) {
                    if (traceOrDebugOn) {
                        this.traceOrDebug(traceOn, "Creating a connection from the XQDataSource ");
                    }
                    this.cachedConnection = this.cachedXQDataSource.getConnection();
                }
                if (reLoad || this.querySource == null || this.cachedPreparedExpression == null || this.cachedPreparedExpression != null && this.cachedPreparedExpression.isClosed()) {
                    Object o = synCtx.getEntry(this.queryKey);
                    if (o instanceof OMElement) {
                        this.querySource = ((OMElement)o).getText();
                    } else if (o instanceof String) {
                        this.querySource = (String)o;
                    }
                    if (this.querySource != null) {
                        if (traceOrDebugOn) {
                            this.traceOrDebug(traceOn, "Picked up the xquery source " + this.querySource + "from the key " + this.queryKey);
                            this.traceOrDebug(traceOn, "Prepare an expression for the query ");
                        }
                        this.cachedPreparedExpression = this.cachedConnection.prepareExpression(this.querySource);
                        needBind = true;
                    } else {
                        if (traceOrDebugOn) {
                            this.traceOrDebug(traceOn, "Couldn't find the xquery source with a key " + this.queryKey);
                        }
                        return;
                    }
                }
                if (this.variables != null & !this.variables.isEmpty()) {
                    if (traceOrDebugOn) {
                        this.traceOrDebug(traceOn, "Binding  external variables to the DynamicContext");
                    }
                    for (i = 0; i < this.variables.size(); ++i) {
                        MediatorVariable variable = (MediatorVariable)this.variables.get(i);
                        boolean hasValueChanged = variable.evaluateValue(synCtx);
                        if (!hasValueChanged && !needBind) continue;
                        this.bindVariable((XQDynamicContext)this.cachedPreparedExpression, variable, traceOrDebugOn, traceOn);
                    }
                }
                resultSequence = this.cachedPreparedExpression.executeQuery();
            }
            if (resultSequence == null) {
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Result Sequence is null");
                }
                return;
            }
            if (resultSequence.next()) {
                OMNode destination;
                XQItem xqItem = resultSequence.getItem();
                if (xqItem == null) {
                    return;
                }
                XQItemType itemType = xqItem.getItemType();
                if (itemType == null) {
                    return;
                }
                int itemKind = itemType.getItemKind();
                int baseType = itemType.getBaseType();
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "The XQuery Result " + xqItem.getItemAsString());
                }
                if ((destination = this.getTargetNode(synCtx)) != null) {
                    if (traceOrDebugOn) {
                        this.traceOrDebug(traceOn, "The target node " + destination);
                    }
                    if (5 == itemKind || 6 == itemKind || 4 == itemKind) {
                        StAXOMBuilder builder = new StAXOMBuilder(XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(xqItem.getItemAsString())));
                        OMElement resultOM = builder.getDocumentElement();
                        if (resultOM != null) {
                            destination.insertSiblingAfter((OMNode)resultOM);
                            destination.detach();
                        }
                    } else if (14 == baseType || 13 == baseType) {
                        ((OMElement)destination).setText(String.valueOf(xqItem.getInt()));
                    } else if (11 == baseType) {
                        ((OMElement)destination).setText(String.valueOf(xqItem.getBoolean()));
                    } else if (19 == baseType) {
                        ((OMElement)destination).setText(String.valueOf(xqItem.getDouble()));
                    } else if (21 == baseType) {
                        ((OMElement)destination).setText(String.valueOf(xqItem.getFloat()));
                    } else if (16 == baseType) {
                        ((OMElement)destination).setText(String.valueOf(xqItem.getLong()));
                    } else if (15 == baseType) {
                        ((OMElement)destination).setText(String.valueOf(xqItem.getShort()));
                    } else if (32 == baseType) {
                        ((OMElement)destination).setText(String.valueOf(xqItem.getByte()));
                    } else if (30 == baseType) {
                        ((OMElement)destination).setText(String.valueOf(xqItem.getItemAsString()));
                    }
                }
            }
            resultSequence.close();
        }
        catch (XQException e) {
            this.handleException("Error during the querying " + e.getMessage(), (Exception)((Object)e));
        }
        catch (XMLStreamException e) {
            this.handleException("Error during retrieving  the Doument Node as  the result " + e.getMessage(), e);
        }
    }

    private void bindVariable(XQDynamicContext xqDynamicContext, MediatorVariable variable, boolean traceOrDebugOn, boolean traceOn) throws XQException {
        if (variable != null) {
            QName name = variable.getName();
            int type = variable.getType();
            Object value = variable.getValue();
            if (value != null && type != -1) {
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Binding a variable to the DynamicContext with a name : " + name + " and a value : " + value);
                }
                switch (type) {
                    case 11: {
                        boolean booleanValue = false;
                        if (value instanceof String) {
                            booleanValue = Boolean.parseBoolean((String)value);
                        } else if (value instanceof Boolean) {
                            booleanValue = (Boolean)value;
                        } else {
                            this.handleException("Incompatible type for the Boolean");
                        }
                        xqDynamicContext.bindBoolean(name, booleanValue, null);
                        break;
                    }
                    case 14: {
                        int intValue = -1;
                        if (value instanceof String) {
                            try {
                                intValue = Integer.parseInt((String)value);
                            }
                            catch (NumberFormatException e) {
                                this.handleException("Incompatible value '" + value + "' " + "for the Integer", e);
                            }
                        } else if (value instanceof Integer) {
                            intValue = (Integer)value;
                        } else {
                            this.handleException("Incompatible type for the Integer");
                        }
                        if (intValue == -1) break;
                        xqDynamicContext.bindInt(name, intValue, null);
                        break;
                    }
                    case 13: {
                        int intValue = -1;
                        if (value instanceof String) {
                            try {
                                intValue = Integer.parseInt((String)value);
                            }
                            catch (NumberFormatException e) {
                                this.handleException("Incompatible value '" + value + "' for the Int", e);
                            }
                        } else if (value instanceof Integer) {
                            intValue = (Integer)value;
                        } else {
                            this.handleException("Incompatible type for the Int");
                        }
                        if (intValue == -1) break;
                        xqDynamicContext.bindInt(name, intValue, null);
                        break;
                    }
                    case 16: {
                        long longValue = -1L;
                        if (value instanceof String) {
                            try {
                                longValue = Long.parseLong((String)value);
                            }
                            catch (NumberFormatException e) {
                                this.handleException("Incompatible value '" + value + "' " + "for the long ", e);
                            }
                        } else if (value instanceof Long) {
                            longValue = (Long)value;
                        } else {
                            this.handleException("Incompatible type for the Long");
                        }
                        if (longValue == -1L) break;
                        xqDynamicContext.bindLong(name, longValue, null);
                        break;
                    }
                    case 15: {
                        short shortValue = -1;
                        if (value instanceof String) {
                            try {
                                shortValue = Short.parseShort((String)value);
                            }
                            catch (NumberFormatException e) {
                                this.handleException("Incompatible value '" + value + "' " + "for the short ", e);
                            }
                        } else if (value instanceof Short) {
                            shortValue = (Short)value;
                        } else {
                            this.handleException("Incompatible type for the Short");
                        }
                        if (shortValue == -1) break;
                        xqDynamicContext.bindShort(name, shortValue, null);
                        break;
                    }
                    case 19: {
                        double doubleValue = -1.0;
                        if (value instanceof String) {
                            try {
                                doubleValue = Double.parseDouble((String)value);
                            }
                            catch (NumberFormatException e) {
                                this.handleException("Incompatible value '" + value + "' " + "for the double ", e);
                            }
                        } else if (value instanceof Double) {
                            doubleValue = (Double)value;
                        } else {
                            this.handleException("Incompatible type for the Double");
                        }
                        if (doubleValue == -1.0) break;
                        xqDynamicContext.bindDouble(name, doubleValue, null);
                        break;
                    }
                    case 21: {
                        float floatValue = -1.0f;
                        if (value instanceof String) {
                            try {
                                floatValue = Float.parseFloat((String)value);
                            }
                            catch (NumberFormatException e) {
                                this.handleException("Incompatible value '" + value + "' " + "for the float ", e);
                            }
                        } else if (value instanceof Float) {
                            floatValue = ((Float)value).floatValue();
                        } else {
                            this.handleException("Incompatible type for the Float");
                        }
                        if (floatValue == -1.0f) break;
                        xqDynamicContext.bindFloat(name, floatValue, null);
                        break;
                    }
                    case 32: {
                        byte byteValue = -1;
                        if (value instanceof String) {
                            try {
                                byteValue = Byte.parseByte((String)value);
                            }
                            catch (NumberFormatException e) {
                                this.handleException("Incompatible value '" + value + "' " + "for the byte ", e);
                            }
                        } else if (value instanceof Byte) {
                            byteValue = (Byte)value;
                        } else {
                            this.handleException("Incompatible type for the Byte");
                        }
                        if (byteValue == -1) break;
                        xqDynamicContext.bindByte(name, byteValue, null);
                        break;
                    }
                    case 30: {
                        if (value instanceof String) {
                            xqDynamicContext.bindObject(name, value, null);
                            break;
                        }
                        this.handleException("Incompatible type for the String");
                        break;
                    }
                    case 4: {
                        if (!(value instanceof OMNode)) break;
                        if (this.useDOMSource) {
                            xqDynamicContext.bindObject(name, (Object)new DOMSource(((Element)ElementHelper.importOMElement((OMElement)((OMElement)value), (OMFactory)DOOMAbstractFactory.getOMFactory())).getOwnerDocument()), null);
                            break;
                        }
                        xqDynamicContext.bindDocument(name, new InputSource(SynapseConfigUtils.getInputStream((Object)value)));
                        break;
                    }
                    case 6: {
                        if (!(value instanceof OMNode)) break;
                        if (this.useDOMSource) {
                            xqDynamicContext.bindObject(name, (Object)new DOMSource(((Element)ElementHelper.importOMElement((OMElement)((OMElement)value), (OMFactory)DOOMAbstractFactory.getOMFactory())).getOwnerDocument()), null);
                            break;
                        }
                        xqDynamicContext.bindDocument(name, new InputSource(SynapseConfigUtils.getInputStream((Object)value)));
                        break;
                    }
                    case 5: {
                        if (!(value instanceof OMNode)) break;
                        if (this.useDOMSource) {
                            xqDynamicContext.bindObject(name, (Object)new DOMSource(((Element)ElementHelper.importOMElement((OMElement)((OMElement)value), (OMFactory)DOOMAbstractFactory.getOMFactory())).getOwnerDocument()), null);
                            break;
                        }
                        xqDynamicContext.bindDocument(name, new InputSource(SynapseConfigUtils.getInputStream((Object)value)));
                        break;
                    }
                    default: {
                        this.handleException("Unsupported  type for the binding type" + type + " in the variable name " + name);
                    }
                }
            }
        }
    }

    public OMNode getTargetNode(MessageContext synCtx) {
        try {
            Object o = this.target.evaluate((Object)synCtx.getEnvelope());
            if (o instanceof OMNode) {
                return (OMNode)o;
            }
            if (o instanceof List && !((List)o).isEmpty()) {
                Object nodeObject = ((List)o).get(0);
                if (nodeObject instanceof OMNode) {
                    return (OMNode)nodeObject;
                }
                this.handleException("The evaluation of the XPath expression " + this.target + " must target in an OMNode");
            } else {
                this.handleException("The evaluation of the XPath expression " + this.target + " must target in an OMNode");
            }
        }
        catch (JaxenException e) {
            this.handleException("Error evaluating XPath " + this.target + " on message" + synCtx.getEnvelope());
        }
        return null;
    }

    private void handleException(String msg, Exception e) {
        this.log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, (Throwable)e);
    }

    private void handleException(String msg) {
        this.log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public String getQueryKey() {
        return this.queryKey;
    }

    public void setQueryKey(String queryKey) {
        this.queryKey = queryKey;
    }

    public String getQuerySource() {
        return this.querySource;
    }

    public void setQuerySource(String querySource) {
        this.querySource = querySource;
    }

    public void addAllVariables(List list) {
        this.variables.addAll(list);
    }

    public void addVariable(MediatorVariable variable) {
        this.variables.add(variable);
    }

    public List getDataSourceProperties() {
        return this.dataSourceProperties;
    }

    public List getVariables() {
        return this.variables;
    }

    public AXIOMXPath getTarget() {
        return this.target;
    }

    public void setTarget(AXIOMXPath target) {
        this.target = target;
    }

    public void addAllDataSoureProperties(List list) {
        this.dataSourceProperties.addAll(list);
    }

    public boolean isUseDOMSource() {
        return this.useDOMSource;
    }

    public void setUseDOMSource(boolean useDOMSource) {
        this.useDOMSource = useDOMSource;
    }
}

