/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.spring;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.MediatorSerializer;
import org.apache.synapse.mediators.spring.SpringMediator;

public class SpringMediatorSerializer
extends AbstractMediatorSerializer
implements MediatorSerializer {
    private static final OMNamespace sprNS = fac.createOMNamespace("http://ws.apache.org/ns/synapse/spring", "spring");
    private static final Log log = LogFactory.getLog(SpringMediatorSerializer.class);

    public OMElement serializeMediator(OMElement parent, Mediator m) {
        if (!(m instanceof SpringMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        SpringMediator mediator = (SpringMediator)m;
        OMElement spring = fac.createOMElement("spring", sprNS);
        if (mediator.getBeanName() != null) {
            spring.addAttribute(fac.createOMAttribute("bean", nullNS, mediator.getBeanName()));
        } else {
            this.handleException("Invalid mediator. Bean name required.");
        }
        SpringMediatorSerializer.saveTracingState((OMElement)spring, (Mediator)mediator);
        if (mediator.getConfigKey() != null) {
            spring.addAttribute(fac.createOMAttribute("key", nullNS, mediator.getConfigKey()));
        }
        if (parent != null) {
            parent.addChild((OMNode)spring);
        }
        return spring;
    }

    public String getMediatorClassName() {
        return SpringMediator.class.getName();
    }
}

