/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Iterator;
import org.apache.axis2.transport.http.server.AxisHttpConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestFactory;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.impl.DefaultHttpRequestFactory;
import org.apache.http.impl.entity.StrictContentLengthStrategy;
import org.apache.http.impl.io.ChunkedInputStream;
import org.apache.http.impl.io.ChunkedOutputStream;
import org.apache.http.impl.io.ContentLengthInputStream;
import org.apache.http.impl.io.ContentLengthOutputStream;
import org.apache.http.impl.io.HttpDataInputStream;
import org.apache.http.impl.io.IdentityOutputStream;
import org.apache.http.impl.io.SocketHttpDataReceiver;
import org.apache.http.impl.io.SocketHttpDataTransmitter;
import org.apache.http.io.HttpDataReceiver;
import org.apache.http.io.HttpDataTransmitter;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicRequestLine;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.message.BufferedHeader;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.HeaderUtils;

public class AxisHttpConnectionImpl
implements AxisHttpConnection {
    private static final Log HEADERLOG = LogFactory.getLog((String)"org.apache.axis2.transport.http.server.wire");
    private final Socket socket;
    private final HttpDataTransmitter datatransmitter;
    private final HttpDataReceiver datareceiver;
    private final CharArrayBuffer charbuffer;
    private final HttpRequestFactory requestfactory;
    private final ContentLengthStrategy contentLenStrategy;
    private final int maxHeaderCount;
    private final int maxLineLen;
    private OutputStream out = null;
    private InputStream in = null;

    public AxisHttpConnectionImpl(Socket socket, HttpParams params) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay((HttpParams)params));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout((HttpParams)params));
        int linger = HttpConnectionParams.getLinger((HttpParams)params);
        if (linger >= 0) {
            socket.setSoLinger(linger > 0, linger);
        }
        int buffersize = HttpConnectionParams.getSocketBufferSize((HttpParams)params);
        this.socket = socket;
        this.datatransmitter = new SocketHttpDataTransmitter(socket, buffersize, params);
        this.datareceiver = new SocketHttpDataReceiver(socket, buffersize, params);
        this.charbuffer = new CharArrayBuffer(256);
        this.requestfactory = new DefaultHttpRequestFactory();
        this.contentLenStrategy = new StrictContentLengthStrategy();
        this.maxHeaderCount = params.getIntParameter("http.connection.max-header-count", -1);
        this.maxLineLen = params.getIntParameter("http.connection.max-line-length", -1);
    }

    public void close() throws IOException {
        this.datatransmitter.flush();
        try {
            this.socket.shutdownOutput();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        try {
            this.socket.shutdownInput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket.close();
    }

    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    public boolean isStale() {
        try {
            this.datareceiver.isDataAvailable(1);
            return false;
        }
        catch (IOException ex) {
            return true;
        }
    }

    public void shutdown() throws IOException {
        Socket tmpsocket = this.socket;
        if (tmpsocket != null) {
            tmpsocket.close();
        }
    }

    public HttpRequest receiveRequest() throws HttpException, IOException {
        this.charbuffer.clear();
        int i = this.datareceiver.readLine(this.charbuffer);
        if (i == -1) {
            throw new ConnectionClosedException("Client closed connection");
        }
        RequestLine requestline = BasicRequestLine.parse((CharArrayBuffer)this.charbuffer, (int)0, (int)this.charbuffer.length());
        HttpRequest request = this.requestfactory.newHttpRequest(requestline);
        Header[] headers = HeaderUtils.parseHeaders((HttpDataReceiver)this.datareceiver, (int)this.maxHeaderCount, (int)this.maxLineLen);
        request.setHeaders(headers);
        if (HEADERLOG.isDebugEnabled()) {
            HEADERLOG.debug((Object)(">> " + request.getRequestLine().toString()));
            for (i = 0; i < headers.length; ++i) {
                HEADERLOG.debug((Object)(">> " + headers[i].toString()));
            }
        }
        this.in = null;
        if (request instanceof HttpEntityEnclosingRequest) {
            long len = this.contentLenStrategy.determineLength((HttpMessage)request);
            this.in = len == -2L ? new ChunkedInputStream(this.datareceiver) : (len == -1L ? new HttpDataInputStream(this.datareceiver) : new ContentLengthInputStream(this.datareceiver, len));
        }
        return request;
    }

    public void sendResponse(HttpResponse response) throws HttpException, IOException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        if (HEADERLOG.isDebugEnabled()) {
            HEADERLOG.debug((Object)("<< " + response.getStatusLine().toString()));
            Header[] headers = response.getAllHeaders();
            for (int i = 0; i < headers.length; ++i) {
                HEADERLOG.debug((Object)("<< " + headers[i].toString()));
            }
        }
        this.charbuffer.clear();
        BasicStatusLine.format((CharArrayBuffer)this.charbuffer, (StatusLine)response.getStatusLine());
        this.datatransmitter.writeLine(this.charbuffer);
        Iterator it = response.headerIterator();
        while (it.hasNext()) {
            Header header = (Header)it.next();
            if (header instanceof BufferedHeader) {
                this.datatransmitter.writeLine(((BufferedHeader)header).getBuffer());
                continue;
            }
            this.charbuffer.clear();
            BasicHeader.format((CharArrayBuffer)this.charbuffer, (Header)header);
            this.datatransmitter.writeLine(this.charbuffer);
        }
        this.charbuffer.clear();
        this.datatransmitter.writeLine(this.charbuffer);
        this.out = null;
        HttpVersion ver = response.getStatusLine().getHttpVersion();
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            long len = entity.getContentLength();
            this.out = entity.isChunked() && ver.greaterEquals(HttpVersion.HTTP_1_1) ? new ChunkedOutputStream(this.datatransmitter) : (len >= 0L ? new ContentLengthOutputStream(this.datatransmitter, len) : new IdentityOutputStream(this.datatransmitter));
        } else {
            this.datatransmitter.flush();
        }
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        } else {
            this.datatransmitter.flush();
        }
    }

    public void reset() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
        if (this.out != null) {
            this.out.flush();
            this.out.close();
            this.out = null;
        }
    }

    public int getSocketTimeout() {
        try {
            return this.socket.getSoTimeout();
        }
        catch (SocketException ex) {
            return -1;
        }
    }

    public void setSocketTimeout(int timeout) {
        try {
            this.socket.setSoTimeout(timeout);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public InetAddress getLocalAddress() {
        if (this.socket != null) {
            return this.socket.getLocalAddress();
        }
        return null;
    }

    public int getLocalPort() {
        if (this.socket != null) {
            return this.socket.getLocalPort();
        }
        return -1;
    }

    public InetAddress getRemoteAddress() {
        if (this.socket != null) {
            return this.socket.getInetAddress();
        }
        return null;
    }

    public int getRemotePort() {
        if (this.socket != null) {
            return this.socket.getPort();
        }
        return -1;
    }

    public HttpConnectionMetrics getMetrics() {
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        if (this.isOpen()) {
            buffer.append(this.socket.getInetAddress());
        } else {
            buffer.append("closed");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

