/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL2Constants;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.WSDLSerializationUtil;
import org.apache.axis2.util.XMLUtils;
import org.apache.ws.commons.schema.XmlSchema;

public class AxisService2WSDL20
implements WSDL2Constants {
    private AxisService axisService;
    private String[] eprs = null;
    private OMNamespace wsaw;

    public AxisService2WSDL20(AxisService service) {
        this.axisService = service;
    }

    public OMElement generateOM() throws Exception {
        Map nameSpacesMap = this.axisService.getNamespaceMap();
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMNamespace wsdl = nameSpacesMap != null && nameSpacesMap.containsValue("http://www.w3.org/ns/wsdl") ? omFactory.createOMNamespace("http://www.w3.org/ns/wsdl", WSDLSerializationUtil.getPrefix("http://www.w3.org/ns/wsdl", nameSpacesMap)) : omFactory.createOMNamespace("http://www.w3.org/ns/wsdl", "wsdl2");
        OMElement descriptionElement = omFactory.createOMElement("description", wsdl);
        WSDLSerializationUtil.populateNamespaces(descriptionElement, nameSpacesMap);
        descriptionElement.declareNamespace(this.axisService.getTargetNamespace(), this.axisService.getTargetNamespacePrefix());
        this.wsaw = descriptionElement.declareNamespace("http://www.w3.org/2006/05/addressing/wsdl", "wsaw");
        OMAttribute targetNamespace = omFactory.createOMAttribute("targetNamespace", null, this.axisService.getTargetNamespace());
        descriptionElement.addAttribute(targetNamespace);
        OMNamespace tns = omFactory.createOMNamespace(this.axisService.getTargetNamespace(), this.axisService.getTargetNamespacePrefix());
        if (nameSpacesMap != null && !nameSpacesMap.containsValue("http://www.w3.org/ns/wsdl")) {
            descriptionElement.declareDefaultNamespace("http://www.w3.org/ns/wsdl");
        }
        OMNamespace wsoap = nameSpacesMap != null && nameSpacesMap.containsValue("http://www.w3.org/ns/wsdl/soap") ? omFactory.createOMNamespace("http://www.w3.org/ns/wsdl/soap", WSDLSerializationUtil.getPrefix("http://www.w3.org/ns/wsdl/soap", nameSpacesMap)) : descriptionElement.declareNamespace("http://www.w3.org/ns/wsdl/soap", "wsoap");
        OMNamespace whttp = nameSpacesMap != null && nameSpacesMap.containsValue("http://www.w3.org/ns/wsdl/http") ? omFactory.createOMNamespace("http://www.w3.org/ns/wsdl/http", WSDLSerializationUtil.getPrefix("http://www.w3.org/ns/wsdl/http", nameSpacesMap)) : descriptionElement.declareNamespace("http://www.w3.org/ns/wsdl/http", "whttp");
        OMNamespace wsdlx = nameSpacesMap != null && nameSpacesMap.containsValue("http://www.w3.org/ns/wsdl-extensions") ? omFactory.createOMNamespace("http://www.w3.org/ns/wsdl-extensions", WSDLSerializationUtil.getPrefix("http://www.w3.org/ns/wsdl-extensions", nameSpacesMap)) : descriptionElement.declareNamespace("http://www.w3.org/ns/wsdl-extensions", "wsdlx");
        OMElement documentationElement = omFactory.createOMElement("documentation", wsdl);
        String description = this.axisService.getDocumentation();
        if (description != null) {
            OMText omText;
            if (description.indexOf("<![CDATA[") > -1) {
                description = description.replaceFirst("<!\\[CDATA\\[", "");
                description = description.replaceFirst("\\]\\]>", "");
                omText = omFactory.createOMText(description, 12);
            } else {
                omText = omFactory.createOMText(description);
            }
            documentationElement.addChild((OMNode)omText);
            descriptionElement.addChild((OMNode)documentationElement);
        }
        OMElement typesElement = omFactory.createOMElement("types", wsdl);
        this.axisService.populateSchemaMappings();
        ArrayList schemas = this.axisService.getSchema();
        for (int i = 0; i < schemas.size(); ++i) {
            StringWriter writer = new StringWriter();
            XmlSchema schema = this.axisService.getSchema(i);
            if ("http://www.w3.org/2001/XMLSchema".equals(schema.getTargetNamespace())) continue;
            schema.write((Writer)writer);
            String schemaString = writer.toString();
            if ("".equals(schemaString)) continue;
            try {
                typesElement.addChild(XMLUtils.toOM(new ByteArrayInputStream(schemaString.getBytes())));
                continue;
            }
            catch (XMLStreamException e) {
                throw AxisFault.makeFault(e);
            }
        }
        descriptionElement.addChild((OMNode)typesElement);
        Parameter parameter = this.axisService.getParameter("interface");
        String interfaceName = parameter != null ? (String)parameter.getValue() : "ServiceInterface";
        descriptionElement.addChild((OMNode)this.getInterfaceElement(wsdl, tns, wsdlx, omFactory, interfaceName));
        boolean disableREST = false;
        Parameter disableRESTParameter = this.axisService.getParameter("disableREST");
        if (disableRESTParameter != null && JavaUtils.isTrueExplicitly(disableRESTParameter.getValue())) {
            disableREST = true;
        }
        HashSet<AxisBinding> bindings = new HashSet<AxisBinding>();
        Map endpointMap = this.axisService.getEndpoints();
        if (endpointMap != null && endpointMap.size() > 0) {
            String[] eprs = this.axisService.getEPRs();
            if (eprs == null) {
                eprs = new String[]{this.axisService.getName()};
            }
            OMElement serviceElement = this.getServiceElement(wsdl, tns, omFactory, interfaceName);
            Iterator iterator = endpointMap.values().iterator();
            while (iterator.hasNext()) {
                AxisEndpoint axisEndpoint = (AxisEndpoint)iterator.next();
                AxisBinding axisBinding = axisEndpoint.getBinding();
                String type = axisBinding.getType();
                if ("http://www.w3.org/ns/wsdl/http".equals(type) && disableREST) continue;
                bindings.add(axisBinding);
                for (int i = 0; i < eprs.length; ++i) {
                    String epr = eprs[i];
                    OMElement endpointElement = axisEndpoint.toWSDL20(wsdl, tns, whttp, epr);
                    boolean endpointAlreadyAdded = false;
                    Iterator endpointsAdded = serviceElement.getChildren();
                    while (endpointsAdded.hasNext()) {
                        OMElement endpoint = (OMElement)endpointsAdded.next();
                        if (!endpoint.getAttribute(new QName("binding")).getAttributeValue().equals(endpointElement.getAttribute(new QName("binding")).getAttributeValue()) || !endpoint.getAttribute(new QName("address")).getAttributeValue().equals(endpointElement.getAttribute(new QName("address")).getAttributeValue())) continue;
                        endpointAlreadyAdded = true;
                    }
                    if (endpointAlreadyAdded) continue;
                    serviceElement.addChild((OMNode)endpointElement);
                }
            }
            Iterator iter = bindings.iterator();
            while (iter.hasNext()) {
                AxisBinding binding = (AxisBinding)iter.next();
                descriptionElement.addChild((OMNode)binding.toWSDL20(wsdl, tns, wsoap, whttp, interfaceName, this.axisService.getNamespaceMap(), this.axisService.getWSAddressingFlag(), this.axisService.getName(), this.wsaw));
            }
            descriptionElement.addChild((OMNode)serviceElement);
        } else {
            descriptionElement.addChild((OMNode)WSDLSerializationUtil.generateSOAP11Binding(omFactory, this.axisService, wsdl, wsoap, tns));
            descriptionElement.addChild((OMNode)WSDLSerializationUtil.generateSOAP12Binding(omFactory, this.axisService, wsdl, wsoap, tns));
            if (!disableREST) {
                descriptionElement.addChild((OMNode)WSDLSerializationUtil.generateHTTPBinding(omFactory, this.axisService, wsdl, whttp, tns));
            }
            descriptionElement.addChild((OMNode)WSDLSerializationUtil.generateServiceElement(omFactory, wsdl, tns, this.axisService, disableREST, this.eprs));
        }
        return descriptionElement;
    }

    private OMElement getInterfaceElement(OMNamespace wsdl, OMNamespace tns, OMNamespace wsdlx, OMFactory fac, String interfaceName) {
        OMElement interfaceElement = fac.createOMElement("interface", wsdl);
        interfaceElement.addAttribute(fac.createOMAttribute("name", null, interfaceName));
        Iterator iterator = this.axisService.getOperations();
        ArrayList<OMElement> interfaceOperations = new ArrayList<OMElement>();
        ArrayList<String> interfaceFaults = new ArrayList<String>();
        int i = 0;
        while (iterator.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)iterator.next();
            if (axisOperation.isControlOperation()) continue;
            interfaceOperations.add(i, this.generateInterfaceOperationElement(axisOperation, wsdl, tns, wsdlx));
            ++i;
            Iterator faultsIterator = axisOperation.getFaultMessages().iterator();
            while (faultsIterator.hasNext()) {
                AxisMessage faultMessage = (AxisMessage)faultsIterator.next();
                String name = faultMessage.getName();
                if (interfaceFaults.contains(name)) continue;
                OMElement faultElement = fac.createOMElement("fault", wsdl);
                faultElement.addAttribute(fac.createOMAttribute("name", null, name));
                faultElement.addAttribute(fac.createOMAttribute("element", null, WSDLSerializationUtil.getElementName(faultMessage, this.axisService.getNamespaceMap())));
                interfaceFaults.add(name);
                interfaceElement.addChild((OMNode)faultElement);
            }
        }
        for (i = 0; i < interfaceOperations.size(); ++i) {
            interfaceElement.addChild((OMNode)interfaceOperations.get(i));
        }
        return interfaceElement;
    }

    private OMElement getServiceElement(OMNamespace wsdl, OMNamespace tns, OMFactory omFactory, String interfaceName) {
        OMElement serviceElement = omFactory.createOMElement("service", wsdl);
        serviceElement.addAttribute(omFactory.createOMAttribute("name", null, this.axisService.getName()));
        serviceElement.addAttribute(omFactory.createOMAttribute("interface", null, tns.getPrefix() + ":" + interfaceName));
        return serviceElement;
    }

    public OMElement generateInterfaceOperationElement(AxisOperation axisOperation, OMNamespace wsdl, OMNamespace tns, OMNamespace wsdlx) {
        ArrayList faults;
        AxisMessage outMessage;
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMElement axisOperationElement = omFactory.createOMElement("operation", wsdl);
        WSDLSerializationUtil.addWSDLDocumentationElement(axisOperation, axisOperationElement, omFactory, wsdl);
        axisOperationElement.addAttribute(omFactory.createOMAttribute("name", null, axisOperation.getName().getLocalPart()));
        URI[] opStyle = (URI[])axisOperation.getParameterValue("operationStyle");
        if (opStyle != null && opStyle.length > 0) {
            String style = opStyle[0].toString();
            for (int i = 1; i < opStyle.length; ++i) {
                URI uri = opStyle[i];
                style = style + " " + uri;
            }
            axisOperationElement.addAttribute(omFactory.createOMAttribute("style", null, style));
        }
        axisOperationElement.addAttribute(omFactory.createOMAttribute("pattern", null, axisOperation.getMessageExchangePattern()));
        Parameter param = axisOperation.getParameter("wsdlx:safe");
        if (param != null) {
            axisOperationElement.addAttribute(omFactory.createOMAttribute("safe", wsdlx, param.getValue().toString()));
        }
        AxisService axisService = axisOperation.getAxisService();
        Map nameSpaceMap = axisService.getNamespaceMap();
        AxisMessage inMessage = (AxisMessage)axisOperation.getChild("inMessage");
        if (inMessage != null) {
            OMElement inMessageElement = omFactory.createOMElement("input", wsdl);
            inMessageElement.addAttribute(omFactory.createOMAttribute("element", null, WSDLSerializationUtil.getElementName(inMessage, nameSpaceMap)));
            WSDLSerializationUtil.addWSAWActionAttribute(inMessageElement, axisOperation.getInputAction(), this.wsaw);
            WSDLSerializationUtil.addWSDLDocumentationElement(inMessage, inMessageElement, omFactory, wsdl);
            axisOperationElement.addChild((OMNode)inMessageElement);
        }
        if ((outMessage = (AxisMessage)axisOperation.getChild("outMessage")) != null) {
            OMElement outMessageElement = omFactory.createOMElement("output", wsdl);
            outMessageElement.addAttribute(omFactory.createOMAttribute("element", null, WSDLSerializationUtil.getElementName(outMessage, nameSpaceMap)));
            WSDLSerializationUtil.addWSAWActionAttribute(outMessageElement, axisOperation.getOutputAction(), this.wsaw);
            WSDLSerializationUtil.addWSDLDocumentationElement(outMessage, outMessageElement, omFactory, wsdl);
            axisOperationElement.addChild((OMNode)outMessageElement);
        }
        if ((faults = axisOperation.getFaultMessages()) != null) {
            Iterator iterator = faults.iterator();
            while (iterator.hasNext()) {
                AxisMessage faultMessage = (AxisMessage)iterator.next();
                OMElement faultElement = "in".equals(faultMessage.getDirection()) ? omFactory.createOMElement("infault", wsdl) : omFactory.createOMElement("outfault", wsdl);
                faultElement.addAttribute(omFactory.createOMAttribute("ref", null, tns.getPrefix() + ":" + faultMessage.getName()));
                WSDLSerializationUtil.addWSAWActionAttribute(faultElement, axisOperation.getFaultAction(faultMessage.getName()), this.wsaw);
                WSDLSerializationUtil.addWSDLDocumentationElement(faultMessage, faultElement, omFactory, wsdl);
                axisOperationElement.addChild((OMNode)faultElement);
            }
        }
        return axisOperationElement;
    }

    public void setEPRs(String[] eprs) {
        this.eprs = eprs;
    }
}

