/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.vfs;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.impl.StandardFileSystemManager;
import org.apache.synapse.transport.base.AbstractPollingTransportListener;
import org.apache.synapse.transport.base.BaseConstants;
import org.apache.synapse.transport.base.BaseUtils;
import org.apache.synapse.transport.vfs.PollTableEntry;
import org.apache.synapse.transport.vfs.VFSOutTransportInfo;
import org.apache.synapse.transport.vfs.VFSUtils;

public class VFSTransportListener
extends AbstractPollingTransportListener {
    public static final String TRANSPORT_NAME = "vfs";
    public static final String DELETE = "DELETE";
    public static final String MOVE = "MOVE";
    private final List pollTable = new ArrayList();
    private FileSystemManager fsManager = null;

    public void init(ConfigurationContext cfgCtx, TransportInDescription trpInDesc) throws AxisFault {
        this.setTransportName(TRANSPORT_NAME);
        super.init(cfgCtx, trpInDesc);
        try {
            StandardFileSystemManager fsm = new StandardFileSystemManager();
            fsm.setConfiguration(this.getClass().getClassLoader().getResource("providers.xml"));
            fsm.init();
            this.fsManager = fsm;
        }
        catch (FileSystemException e) {
            this.handleException("Error initializing the file transport : " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public void onPoll() {
        for (PollTableEntry entry : this.pollTable) {
            long startTime = System.currentTimeMillis();
            if (startTime <= entry.getNextPollTime()) continue;
            this.scanFileOrDirectory(entry, entry.getFileURI());
        }
    }

    private void scanFileOrDirectory(PollTableEntry entry, String fileURI) {
        block29: {
            FileObject fileObject = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Scanning directory or file : " + fileURI));
            }
            boolean wasError = true;
            int retryCount = 0;
            int maxRetryCount = entry.getMaxRetryCount();
            long reconnectionTimeout = entry.getReconnectTimeout();
            while (wasError) {
                try {
                    ++retryCount;
                    fileObject = this.fsManager.resolveFile(fileURI);
                    if (fileObject == null) {
                        this.log.error((Object)"fileObject is null");
                        throw new FileSystemException("fileObject is null");
                    }
                    wasError = false;
                }
                catch (FileSystemException e) {
                    this.log.error((Object)"cannot resolve fileObject", (Throwable)e);
                    if (maxRetryCount <= retryCount) {
                        this.processFailure("cannot resolve fileObject repeatedly: " + e.getMessage(), (Exception)((Object)e), entry);
                    }
                    return;
                }
                if (!wasError) continue;
                try {
                    Thread.sleep(reconnectionTimeout);
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
            }
            try {
                if (fileObject.exists() && fileObject.isReadable()) {
                    entry.setLastPollState(3);
                    FileObject[] children = null;
                    try {
                        children = fileObject.getChildren();
                    }
                    catch (FileSystemException ignore) {
                        // empty catch block
                    }
                    if (children == null || children.length == 0) {
                        if (fileObject.getType() == FileType.FILE) {
                            try {
                                this.processFile(entry, fileObject);
                                entry.setLastPollState(0);
                            }
                            catch (AxisFault e) {
                                entry.setLastPollState(2);
                            }
                            this.moveOrDeleteAfterProcessing(entry, fileObject);
                        }
                    } else {
                        int failCount = 0;
                        int successCount = 0;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("File name pattern :" + entry.getFileNamePattern()));
                        }
                        for (int i = 0; i < children.length; ++i) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Matching file :" + children[i].getName().getBaseName()));
                            }
                            if (entry.getFileNamePattern() == null || !children[i].getName().getBaseName().matches(entry.getFileNamePattern())) continue;
                            try {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug((Object)("Processing file :" + children[i]));
                                }
                                this.processFile(entry, children[i]);
                                ++successCount;
                                entry.setLastPollState(0);
                            }
                            catch (Exception e) {
                                this.logException("Error processing File URI : " + children[i].getName(), e);
                                ++failCount;
                                entry.setLastPollState(2);
                            }
                            this.moveOrDeleteAfterProcessing(entry, children[i]);
                        }
                        if (failCount == 0 && successCount > 0) {
                            entry.setLastPollState(0);
                        } else if (successCount == 0 && failCount > 0) {
                            entry.setLastPollState(2);
                        } else {
                            entry.setLastPollState(1);
                        }
                    }
                    long now = System.currentTimeMillis();
                    entry.setLastPollTime(now);
                    entry.setNextPollTime(now + entry.getPollInterval());
                    break block29;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Unable to access or read file or directory : " + fileURI));
                }
            }
            catch (FileSystemException e) {
                this.processFailure("Error checking for existence and readability : " + fileURI, (Exception)((Object)e), entry);
            }
        }
    }

    private void moveOrDeleteAfterProcessing(PollTableEntry entry, FileObject fileObject) {
        block16: {
            String moveToDirectory = null;
            try {
                switch (entry.getLastPollState()) {
                    case 0: {
                        if (entry.getActionAfterProcess() != 1) break;
                        moveToDirectory = entry.getMoveAfterProcess();
                        break;
                    }
                    case 1: {
                        if (entry.getActionAfterProcess() != 1) break;
                        moveToDirectory = entry.getMoveAfterErrors();
                        break;
                    }
                    case 2: {
                        if (entry.getActionAfterProcess() != 1) break;
                        moveToDirectory = entry.getMoveAfterFailure();
                        break;
                    }
                    case 3: {
                        return;
                    }
                }
                if (moveToDirectory != null) {
                    String destName = moveToDirectory + File.separator + fileObject.getName().getBaseName();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Moving to file :" + destName));
                    }
                    FileObject dest = this.fsManager.resolveFile(destName);
                    try {
                        fileObject.moveTo(dest);
                    }
                    catch (FileSystemException e) {
                        this.log.error((Object)("Error moving file : " + fileObject + " to " + moveToDirectory), (Throwable)e);
                    }
                    break block16;
                }
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Deleting file :" + fileObject));
                    }
                    fileObject.close();
                    if (!fileObject.delete()) {
                        this.log.error((Object)("Cannot delete file : " + fileObject));
                    }
                }
                catch (FileSystemException e) {
                    this.log.error((Object)("Error deleting file : " + fileObject), (Throwable)e);
                }
            }
            catch (FileSystemException e) {
                this.log.error((Object)("Error resolving directory to move after processing : " + moveToDirectory), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(PollTableEntry entry, FileObject file) throws AxisFault {
        try {
            Parameter param;
            FileContent content = file.getContent();
            String fileName = file.getName().getBaseName();
            String filePath = file.getName().getPath();
            HashMap<String, Object> transportHeaders = new HashMap<String, Object>();
            transportHeaders.put("FILE_PATH", filePath);
            transportHeaders.put("FILE_NAME", fileName);
            try {
                transportHeaders.put("FILE_LENGTH", content.getSize());
            }
            catch (FileSystemException ignore) {
                // empty catch block
            }
            try {
                transportHeaders.put("LAST_MODIFIED", content.getLastModifiedTime());
            }
            catch (FileSystemException ignore) {
                // empty catch block
            }
            String messageId = filePath + "_" + fileName + "_" + System.currentTimeMillis() + "_" + (int)Math.random() * 1000;
            String contentType = entry.getContentType();
            if (!BaseUtils.isValid(contentType)) {
                if (file.getName().getExtension().toLowerCase().endsWith(".xml")) {
                    contentType = "text/xml";
                } else if (file.getName().getExtension().toLowerCase().endsWith(".txt")) {
                    contentType = "text/plain";
                }
            }
            if (contentType == null) {
                if (entry.getContentType() != null) {
                    contentType = entry.getContentType();
                } else if (VFSUtils.getInstace().getProperty(content, "Content-Type") != null) {
                    contentType = VFSUtils.getInstace().getProperty(content, "Content-Type");
                }
            }
            MessageContext msgContext = this.createMessageContext();
            AxisService service = this.cfgCtx.getAxisConfiguration().getService(entry.getServiceName());
            msgContext.setAxisService(service);
            Parameter operationParam = service.getParameter("Operation");
            QName operationQName = operationParam != null ? BaseUtils.getQNameFromString(operationParam.getValue()) : BaseConstants.DEFAULT_OPERATION;
            AxisOperation operation = service.getOperation(operationQName);
            if (operation != null) {
                msgContext.setAxisOperation(operation);
            }
            if ((param = service.getParameter("transport.vfs.ReplyFileURI")) != null && param.getValue() != null) {
                msgContext.setProperty("OutTransportInfo", (Object)new VFSOutTransportInfo((String)param.getValue()));
            }
            VFSUtils.getInstace().setSOAPEnvelope(content, msgContext, contentType);
            this.handleIncomingMessage(msgContext, transportHeaders, null, contentType);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Processed file : " + file + " of Content-type : " + contentType));
            }
        }
        catch (FileSystemException e) {
            this.handleException("Error reading file content or attributes : " + file, (Exception)((Object)e));
        }
        finally {
            try {
                file.close();
            }
            catch (FileSystemException warn) {
                this.log.warn((Object)("Cannot close file after processing : " + file.getName().getPath()), (Throwable)warn);
            }
        }
    }

    private void processFailure(String msg, Exception e, PollTableEntry entry) {
        if (e == null) {
            this.log.error((Object)msg);
        } else {
            this.log.error((Object)msg, (Throwable)e);
        }
        long now = System.currentTimeMillis();
        entry.setLastPollState(2);
        entry.setLastPollTime(now);
        entry.setNextPollTime(now + entry.getPollInterval());
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        for (PollTableEntry entry : this.pollTable) {
            if (!entry.getServiceName().equals(serviceName)) continue;
            return new EndpointReference[]{new EndpointReference("vfs:" + entry.getFileURI())};
        }
        return null;
    }

    protected void startListeningForService(AxisService service) {
        Parameter param = service.getParameter("transport.PollInterval");
        long pollInterval = 300000L;
        if (param != null && param.getValue() instanceof String) {
            try {
                pollInterval = Integer.parseInt(param.getValue().toString());
            }
            catch (NumberFormatException e) {
                this.log.error((Object)("Invalid poll interval : " + param.getValue() + " for service : " + service.getName() + " default to : " + 300 + "sec"), (Throwable)e);
            }
        }
        PollTableEntry entry = new PollTableEntry();
        try {
            String strReconnectTimeout;
            entry.setFileURI(BaseUtils.getRequiredServiceParam(service, "transport.vfs.FileURI"));
            entry.setFileNamePattern(BaseUtils.getOptionalServiceParam(service, "transport.vfs.FileNamePattern"));
            entry.setContentType(BaseUtils.getRequiredServiceParam(service, "transport.vfs.ContentType"));
            String option = BaseUtils.getOptionalServiceParam(service, "transport.vfs.ActionAfterProcess");
            entry.setActionAfterProcess(MOVE.equals(option) ? 1 : 0);
            option = BaseUtils.getOptionalServiceParam(service, "transport.vfs.ActionAfterErrors");
            entry.setActionAfterErrors(MOVE.equals(option) ? 1 : 0);
            option = BaseUtils.getOptionalServiceParam(service, "transport.vfs.ActionAfterFailure");
            entry.setActionAfterFailure(MOVE.equals(option) ? 1 : 0);
            String moveDirectoryAfterProcess = BaseUtils.getOptionalServiceParam(service, "transport.vfs.MoveAfterProcess");
            entry.setMoveAfterProcess(moveDirectoryAfterProcess);
            String moveDirectoryAfterErrors = BaseUtils.getOptionalServiceParam(service, "transport.vfs.MoveAfterErrors");
            entry.setMoveAfterErrors(moveDirectoryAfterErrors);
            String moveDirectoryAfterFailure = BaseUtils.getOptionalServiceParam(service, "transport.vfs.MoveAfterFailure");
            entry.setMoveAfterFailure(moveDirectoryAfterFailure);
            String strMaxRetryCount = BaseUtils.getOptionalServiceParam(service, "transport.vfs.MaxRetryCount");
            if (strMaxRetryCount != null) {
                entry.setMaxRetryCount(Integer.parseInt(strMaxRetryCount));
            }
            if ((strReconnectTimeout = BaseUtils.getOptionalServiceParam(service, "transport.vfs.ReconnectTimeout")) != null) {
                entry.setReconnectTimeout(Integer.parseInt(strReconnectTimeout) * 1000);
            }
            entry.setServiceName(service.getName());
            this.schedulePoll(service, pollInterval);
            this.pollTable.add(entry);
        }
        catch (AxisFault axisFault) {
            String msg = "Error configuring the File/VFS transport for Service : " + service.getName() + " :: " + axisFault.getMessage();
            this.log.warn((Object)msg);
        }
    }

    protected void stopListeningForService(AxisService service) {
        for (PollTableEntry entry : this.pollTable) {
            if (!service.getName().equals(entry.getServiceName())) continue;
            this.cancelPoll(service);
            this.pollTable.remove(entry);
        }
    }
}

