/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axiom.soap.impl.llom.soap12.SOAP12Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.synapse.transport.nhttp.Axis2HttpRequest;
import org.apache.synapse.transport.nhttp.ClientWorker;
import org.apache.synapse.transport.nhttp.ConnectionPool;
import org.apache.synapse.transport.nhttp.NHttpConfiguration;
import org.apache.synapse.transport.nhttp.util.PipeImpl;
import org.apache.synapse.transport.nhttp.util.WorkerPool;
import org.apache.synapse.transport.nhttp.util.WorkerPoolFactory;

public class ClientHandler
implements NHttpClientHandler {
    private static final Log log = LogFactory.getLog(ClientHandler.class);
    private final HttpParams params;
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy connStrategy;
    ConfigurationContext cfgCtx = null;
    private NHttpConfiguration cfg = null;
    private WorkerPool workerPool = null;
    private static final String REQUEST_BUFFER = "request-buffer";
    private static final String RESPONSE_BUFFER = "response-buffer";
    private static final String OUTGOING_MESSAGE_CONTEXT = "axis2_message_context";
    private static final String REQUEST_SOURCE_CHANNEL = "request-source-channel";
    private static final String RESPONSE_SINK_CHANNEL = "request-sink-channel";
    private static final String CONTENT_TYPE = "Content-Type";

    public ClientHandler(ConfigurationContext cfgCtx, HttpParams params) {
        this.cfgCtx = cfgCtx;
        this.params = params;
        this.httpProcessor = this.getHttpProcessor();
        this.connStrategy = new DefaultConnectionReuseStrategy();
        this.cfg = NHttpConfiguration.getInstance();
        this.workerPool = WorkerPoolFactory.getWorkerPool(this.cfg.getClientCoreThreads(), this.cfg.getClientMaxThreads(), this.cfg.getClientKeepalive(), this.cfg.getClientQueueLen(), "Client Worker thread group", "HttpClientWorker");
    }

    public void requestReady(NHttpClientConnection conn) {
    }

    public void submitRequest(NHttpClientConnection conn, Axis2HttpRequest axis2Req) {
        try {
            HttpContext context = conn.getContext();
            context.setAttribute("http.connection", (Object)conn);
            context.setAttribute("http.target_host", (Object)axis2Req.getHttpHost());
            context.setAttribute(OUTGOING_MESSAGE_CONTEXT, (Object)axis2Req.getMsgContext());
            context.setAttribute(REQUEST_SOURCE_CHANNEL, (Object)axis2Req.getSourceChannel());
            HttpRequest request = axis2Req.getRequest();
            request.setParams((HttpParams)new DefaultedHttpParams(request.getParams(), this.params));
            this.httpProcessor.process(request, context);
            conn.submitRequest(request);
            context.setAttribute("http.request", (Object)request);
        }
        catch (IOException e) {
            this.handleException("I/O Error : " + e.getMessage(), e, conn);
        }
        catch (HttpException e) {
            this.handleException("Unexpected HTTP protocol error: " + e.getMessage(), (Exception)((Object)e), conn);
        }
    }

    public void connected(NHttpClientConnection conn, Object attachment) {
        try {
            HttpContext context = conn.getContext();
            Axis2HttpRequest axis2Req = (Axis2HttpRequest)attachment;
            context.setAttribute("http.connection", (Object)conn);
            context.setAttribute("http.target_host", (Object)axis2Req.getHttpHost());
            context.setAttribute(REQUEST_BUFFER, (Object)ByteBuffer.allocate(this.cfg.getBufferZise()));
            context.setAttribute(RESPONSE_BUFFER, (Object)ByteBuffer.allocate(this.cfg.getBufferZise()));
            context.setAttribute(OUTGOING_MESSAGE_CONTEXT, (Object)axis2Req.getMsgContext());
            context.setAttribute(REQUEST_SOURCE_CHANNEL, (Object)axis2Req.getSourceChannel());
            HttpRequest request = axis2Req.getRequest();
            request.setParams((HttpParams)new DefaultedHttpParams(request.getParams(), this.params));
            this.httpProcessor.process(request, context);
            conn.submitRequest(request);
            context.setAttribute("http.request", (Object)request);
        }
        catch (IOException e) {
            this.handleException("I/O Error : " + e.getMessage(), e, conn);
        }
        catch (HttpException e) {
            this.handleException("Unexpected HTTP protocol error: " + e.getMessage(), (Exception)((Object)e), conn);
        }
    }

    public void closed(NHttpClientConnection conn) {
        log.trace((Object)"Connection closed");
    }

    public void timeout(NHttpClientConnection conn) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Connection Timeout");
        }
        this.shutdownConnection((HttpConnection)conn);
    }

    public void exception(NHttpClientConnection conn, HttpException e) {
        log.error((Object)("HTTP protocol violation : " + e.getMessage()));
        this.shutdownConnection((HttpConnection)conn);
    }

    public void exception(NHttpClientConnection conn, IOException e) {
        log.error((Object)("I/O error : " + e.getMessage()), (Throwable)e);
        this.shutdownConnection((HttpConnection)conn);
    }

    public void inputReady(NHttpClientConnection conn, ContentDecoder decoder) {
        HttpContext context = conn.getContext();
        HttpResponse response = conn.getHttpResponse();
        WritableByteChannel sink = (WritableByteChannel)context.getAttribute(RESPONSE_SINK_CHANNEL);
        ByteBuffer inbuf = (ByteBuffer)context.getAttribute(REQUEST_BUFFER);
        try {
            while (decoder.read(inbuf) > 0) {
                inbuf.flip();
                sink.write(inbuf);
                inbuf.compact();
            }
            if (decoder.isCompleted()) {
                if (sink != null) {
                    sink.close();
                }
                if (!this.connStrategy.keepAlive(response, context)) {
                    conn.close();
                } else {
                    ConnectionPool.release(conn);
                }
            }
        }
        catch (IOException e) {
            this.handleException("I/O Error : " + e.getMessage(), e, conn);
        }
    }

    public void outputReady(NHttpClientConnection conn, ContentEncoder encoder) {
        HttpContext context = conn.getContext();
        ReadableByteChannel source = (ReadableByteChannel)context.getAttribute(REQUEST_SOURCE_CHANNEL);
        ByteBuffer outbuf = (ByteBuffer)context.getAttribute(RESPONSE_BUFFER);
        try {
            int bytesRead = source.read(outbuf);
            if (bytesRead == -1) {
                encoder.complete();
            } else {
                outbuf.flip();
                encoder.write(outbuf);
                outbuf.compact();
            }
            if (encoder.isCompleted()) {
                source.close();
            }
        }
        catch (IOException e) {
            this.handleException("I/O Error : " + e.getMessage(), e, conn);
        }
    }

    public void responseReceived(NHttpClientConnection conn) {
        HttpContext context = conn.getContext();
        HttpResponse response = conn.getHttpResponse();
        switch (response.getStatusLine().getStatusCode()) {
            case 202: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Received a 202 Accepted response");
                }
                MessageContext outMsgCtx = (MessageContext)context.getAttribute(OUTGOING_MESSAGE_CONTEXT);
                MessageReceiver mr = outMsgCtx.getAxisOperation().getMessageReceiver();
                try {
                    MessageContext responseMsgCtx = outMsgCtx.getOperationContext().getMessageContext("In");
                    if (responseMsgCtx == null) {
                        return;
                    }
                    responseMsgCtx.setServerSide(true);
                    responseMsgCtx.setDoingREST(outMsgCtx.isDoingREST());
                    responseMsgCtx.setProperty("TRANSPORT_IN", outMsgCtx.getProperty("TRANSPORT_IN"));
                    responseMsgCtx.setTransportIn(outMsgCtx.getTransportIn());
                    responseMsgCtx.setTransportOut(outMsgCtx.getTransportOut());
                    responseMsgCtx.setAxisMessage(outMsgCtx.getAxisOperation().getMessage("In"));
                    responseMsgCtx.setOperationContext(outMsgCtx.getOperationContext());
                    responseMsgCtx.setConfigurationContext(outMsgCtx.getConfigurationContext());
                    responseMsgCtx.setTo(null);
                    if (!outMsgCtx.isDoingREST() && !outMsgCtx.isSOAP11()) {
                        responseMsgCtx.setEnvelope(new SOAP12Factory().getDefaultEnvelope());
                    } else {
                        responseMsgCtx.setEnvelope(new SOAP11Factory().getDefaultEnvelope());
                    }
                    responseMsgCtx.setProperty("disableAddressingForOutMessages", (Object)Boolean.TRUE);
                    responseMsgCtx.setProperty("SC_ACCEPTED", (Object)Boolean.TRUE);
                    mr.receive(responseMsgCtx);
                }
                catch (AxisFault af) {
                    log.error((Object)"Unable to report back 202 Accepted state to the message receiver", (Throwable)af);
                }
                return;
            }
            case 500: {
                Header contentType = response.getFirstHeader(CONTENT_TYPE);
                if (contentType != null) {
                    if (contentType.getValue().indexOf("text/xml") >= 0 || contentType.getValue().indexOf("application/soap+xml") >= 0) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Received an internal server error with a SOAP payload");
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"Received an internal server error with a POX/REST payload");
                    }
                    this.processResponse(conn, context, response);
                    return;
                }
                log.error((Object)("Received an internal server error : " + response.getStatusLine().getReasonPhrase()));
                return;
            }
            case 200: {
                this.processResponse(conn, context, response);
                return;
            }
        }
        log.warn((Object)("Unexpected HTTP status code received : " + response.getStatusLine().getStatusCode() + " :: " + response.getStatusLine().getReasonPhrase()));
        Header contentType = response.getFirstHeader(CONTENT_TYPE);
        if (contentType != null) {
            if (contentType.getValue().indexOf("text/xml") >= 0 || contentType.getValue().indexOf("application/soap+xml") >= 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Received an unexpected response with a SOAP payload");
                }
            } else if (contentType.getValue().indexOf("html") == -1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Received an unexpected response with a POX/REST payload");
                }
            } else {
                log.error((Object)("Received an unexpected response - of content type : " + contentType.getValue() + " and status code : " + response.getStatusLine().getStatusCode() + " with reason : " + response.getStatusLine().getReasonPhrase()));
            }
        } else {
            log.error((Object)("Received an unexpected response - of unknown content type  with status code : " + response.getStatusLine().getStatusCode() + " and reason : " + response.getStatusLine().getReasonPhrase()));
        }
        this.processResponse(conn, context, response);
    }

    private void processResponse(NHttpClientConnection conn, HttpContext context, HttpResponse response) {
        try {
            PipeImpl responsePipe = new PipeImpl();
            context.setAttribute(RESPONSE_SINK_CHANNEL, (Object)responsePipe.sink());
            BasicHttpEntity entity = new BasicHttpEntity();
            if (response.getStatusLine().getProtocolVersion().greaterEquals((ProtocolVersion)HttpVersion.HTTP_1_1)) {
                entity.setChunked(true);
            }
            response.setEntity((HttpEntity)entity);
            context.setAttribute("http.response", (Object)response);
            this.workerPool.execute(new ClientWorker(this.cfgCtx, Channels.newInputStream(responsePipe.source()), response, (MessageContext)context.getAttribute(OUTGOING_MESSAGE_CONTEXT)));
        }
        catch (IOException e) {
            this.handleException("I/O Error : " + e.getMessage(), e, conn);
        }
    }

    private void handleException(String msg, Exception e, NHttpClientConnection conn) {
        log.error((Object)msg, (Throwable)e);
        if (conn != null) {
            this.shutdownConnection((HttpConnection)conn);
        }
    }

    private void shutdownConnection(HttpConnection conn) {
        try {
            conn.shutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private HttpProcessor getHttpProcessor() {
        BasicHttpProcessor httpProcessor = new BasicHttpProcessor();
        httpProcessor.addInterceptor((HttpRequestInterceptor)new RequestContent());
        httpProcessor.addInterceptor((HttpRequestInterceptor)new RequestTargetHost());
        httpProcessor.addInterceptor((HttpRequestInterceptor)new RequestConnControl());
        httpProcessor.addInterceptor((HttpRequestInterceptor)new RequestUserAgent());
        httpProcessor.addInterceptor((HttpRequestInterceptor)new RequestExpectContinue());
        return httpProcessor;
    }
}

