/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.jms;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.synapse.transport.base.AbstractTransportListener;
import org.apache.synapse.transport.base.BaseUtils;
import org.apache.synapse.transport.jms.JMSConnectionFactory;
import org.apache.synapse.transport.jms.JMSMessageReceiver;
import org.apache.synapse.transport.jms.JMSUtils;

public class JMSListener
extends AbstractTransportListener {
    public static final String TRANSPORT_NAME = "jms";
    private Map connectionFactories = new HashMap();
    private Map serviceNameToEPRMap = new HashMap();

    public void init(ConfigurationContext cfgCtx, TransportInDescription trpInDesc) throws AxisFault {
        this.setTransportName(TRANSPORT_NAME);
        super.init(cfgCtx, trpInDesc);
        this.loadConnectionFactoryDefinitions(trpInDesc);
        if (this.connectionFactories.isEmpty()) {
            this.log.warn((Object)"No JMS connection factories are defined. Cannot listen for JMS");
            return;
        }
        this.log.info((Object)"JMS Transport Receiver/Listener initialized...");
    }

    public void start() throws AxisFault {
        for (JMSConnectionFactory conFac : this.connectionFactories.values()) {
            conFac.setJmsMessageReceiver(new JMSMessageReceiver(this, conFac, this.workerPool, this.cfgCtx));
            try {
                conFac.connectAndListen();
            }
            catch (JMSException e) {
                this.handleException("Error starting connection factory : " + conFac.getName(), (Exception)((Object)e));
            }
            catch (NamingException e) {
                this.handleException("Error starting connection factory : " + conFac.getName(), e);
            }
        }
        super.start();
    }

    public void stop() throws AxisFault {
        super.stop();
        Iterator iter = this.connectionFactories.values().iterator();
        while (iter.hasNext()) {
            ((JMSConnectionFactory)iter.next()).stop();
        }
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        if (serviceName.indexOf(47) != -1) {
            serviceName = serviceName.substring(0, serviceName.indexOf(47));
        }
        return new EndpointReference[]{new EndpointReference((String)this.serviceNameToEPRMap.get(serviceName))};
    }

    protected void startListeningForService(AxisService service) {
        if (service.getName().startsWith("__")) {
            return;
        }
        JMSConnectionFactory cf = this.getConnectionFactory(service);
        if (cf == null) {
            String msg = "Service " + service.getName() + " does not specify" + "a JMS connection factory or refers to an invalid factory. " + "This service is being marked as faulty and will not be " + "available over the JMS transport";
            this.log.warn((Object)msg);
            BaseUtils.markServiceAsFaulty(service.getName(), msg, service.getAxisConfiguration());
            return;
        }
        String destinationName = JMSUtils.getJNDIDestinationNameForService(service);
        this.serviceNameToEPRMap.put(service.getName(), JMSUtils.getEPR(cf, destinationName));
        String destinationType = JMSUtils.getDestinationTypeForService(service);
        this.log.info((Object)("Starting to listen on destination : " + destinationName + " of type " + destinationType + " for service " + service.getName()));
        cf.addDestination(destinationName, destinationType, service.getName());
        cf.startListeningOnDestination(destinationName, destinationType);
    }

    protected void stopListeningForService(AxisService service) {
        JMSConnectionFactory cf = this.getConnectionFactory(service);
        if (cf != null) {
            this.serviceNameToEPRMap.remove(service.getName());
            String destination = JMSUtils.getJNDIDestinationNameForService(service);
            cf.removeDestination(destination);
        }
    }

    private JMSConnectionFactory getConnectionFactory(AxisService service) {
        Parameter conFacParam = service.getParameter("transport.jms.ConnectionFactory");
        if (conFacParam != null) {
            String conFac = (String)conFacParam.getValue();
            if (this.connectionFactories.containsKey(conFac)) {
                return (JMSConnectionFactory)this.connectionFactories.get(conFac);
            }
            return null;
        }
        if (this.connectionFactories.containsKey("default")) {
            return (JMSConnectionFactory)this.connectionFactories.get("default");
        }
        return null;
    }

    private void loadConnectionFactoryDefinitions(TransportInDescription transprtIn) {
        for (Parameter conFacParams : transprtIn.getParameters()) {
            JMSConnectionFactory jmsConFactory = new JMSConnectionFactory(conFacParams.getName(), this.cfgCtx);
            JMSUtils.setConnectionFactoryParameters(conFacParams, jmsConFactory);
            this.connectionFactories.put(jmsConFactory.getName(), jmsConFactory);
        }
    }
}

