/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage.inmemory;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beans.RMBean;
import org.apache.sandesha2.storage.inmemory.InMemoryStorageManager;
import org.apache.sandesha2.workers.SandeshaThread;

public class InMemoryTransaction
implements Transaction {
    private static final Log log = LogFactory.getLog((Class)InMemoryTransaction.class);
    private InMemoryStorageManager manager;
    private String threadName;
    private int threadId;
    private ArrayList enlistedBeans = new ArrayList();
    private InMemoryTransaction waitingForTran = null;
    private boolean sentMessages = false;
    private boolean receivedMessages = false;
    private boolean active = true;

    InMemoryTransaction(InMemoryStorageManager manager, String threadName, int id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entry: InMemoryTransaction::<init>");
        }
        this.manager = manager;
        this.threadName = threadName;
        this.threadId = id;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: InMemoryTransaction::<init>, " + this));
        }
    }

    public void commit() {
        SandeshaThread invoker;
        this.releaseLocks();
        if (this.sentMessages) {
            this.manager.getSender().wakeThread();
        }
        if (this.receivedMessages && (invoker = this.manager.getInvoker()) != null) {
            invoker.wakeThread();
        }
        this.active = false;
    }

    public void rollback() {
        this.releaseLocks();
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enlist(RMBean bean) throws SandeshaStorageException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entry: InMemoryTransaction::enlist, " + bean));
        }
        if (bean != null) {
            RMBean rMBean = bean;
            synchronized (rMBean) {
                InMemoryTransaction other = (InMemoryTransaction)bean.getTransaction();
                while (other != null && other != this) {
                    this.waitingForTran = other;
                    if (!this.enlistedBeans.isEmpty()) {
                        HashSet<InMemoryTransaction> set = new HashSet<InMemoryTransaction>();
                        set.add(this);
                        while (other != null) {
                            if (set.contains(other)) {
                                String message = SandeshaMessageHelper.getMessage("deadlock", this.toString(), bean.toString());
                                SandeshaStorageException e = new SandeshaStorageException(message);
                                this.waitingForTran = null;
                                this.releaseLocks();
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)message, (Throwable)((Object)e));
                                }
                                throw e;
                            }
                            set.add(other);
                            other = other.waitingForTran;
                        }
                    }
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("This " + this + " waiting for " + this.waitingForTran));
                        }
                        bean.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    other = (InMemoryTransaction)bean.getTransaction();
                }
                this.waitingForTran = null;
                if (other == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(this + " locking bean"));
                    }
                    bean.setTransaction(this);
                    this.enlistedBeans.add(bean);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: InMemoryTransaction::enlist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLocks() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entry: InMemoryTransaction::releaseLocks, " + this));
        }
        this.manager.removeTransaction(this);
        Iterator beans = this.enlistedBeans.iterator();
        while (beans.hasNext()) {
            RMBean bean;
            RMBean rMBean = bean = (RMBean)beans.next();
            synchronized (rMBean) {
                bean.setTransaction(null);
                bean.notifyAll();
            }
        }
        this.enlistedBeans.clear();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: InMemoryTransaction::releaseLocks");
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[InMemoryTransaction, id:");
        result.append(this.threadId);
        result.append(", name: ");
        result.append(this.threadName);
        result.append(", locks: ");
        result.append(this.enlistedBeans.size());
        result.append("]");
        return result.toString();
    }

    public void setReceivedMessages(boolean receivedMessages) {
        this.receivedMessages = receivedMessages;
    }

    public void setSentMessages(boolean sentMessages) {
        this.sentMessages = sentMessages;
    }
}

