/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.msgprocessors;

import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.client.SandeshaListener;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.msgprocessors.MsgProcessor;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.security.SecurityToken;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.util.FaultManager;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.RMMsgCreator;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SequenceManager;
import org.apache.sandesha2.util.TerminateManager;
import org.apache.sandesha2.wsrm.Accept;
import org.apache.sandesha2.wsrm.CreateSequence;
import org.apache.sandesha2.wsrm.CreateSequenceResponse;
import org.apache.sandesha2.wsrm.Endpoint;
import org.apache.sandesha2.wsrm.SequenceOffer;

public class CreateSeqMsgProcessor
implements MsgProcessor {
    private static final Log log = LogFactory.getLog((Class)CreateSeqMsgProcessor.class);

    public boolean processInMessage(RMMsgContext createSeqRMMsg, Transaction transaction) throws AxisFault {
        block31: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Enter: CreateSeqMsgProcessor::processInMessage");
            }
            try {
                EndpointReference replyTo;
                EndpointReference toEPR;
                CreateSequence createSeqPart = (CreateSequence)createSeqRMMsg.getMessagePart(9);
                if (createSeqPart == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)SandeshaMessageHelper.getMessage("noCreateSeqParts"));
                    }
                    FaultManager.makeCreateSequenceRefusedFault(createSeqRMMsg, SandeshaMessageHelper.getMessage("noCreateSeqParts"), new Exception());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exit: CreateSeqMsgProcessor::processInMessage " + Boolean.FALSE));
                    }
                    return false;
                }
                MessageContext createSeqMsg = createSeqRMMsg.getMessageContext();
                ConfigurationContext context = createSeqMsg.getConfigurationContext();
                StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(context, (AxisDescription)context.getAxisConfiguration());
                SecurityManager secManager = SandeshaUtil.getSecurityManager(context);
                OMElement theSTR = createSeqPart.getSecurityTokenReference();
                SecurityToken token = null;
                if (theSTR != null) {
                    MessageContext msgcontext = createSeqRMMsg.getMessageContext();
                    token = secManager.getSecurityToken(theSTR, msgcontext);
                    SOAPBody body = msgcontext.getEnvelope().getBody();
                    secManager.checkProofOfPossession(token, (OMElement)body, msgcontext);
                }
                if ((toEPR = createSeqMsg.getTo()).hasAnonymousAddress()) {
                    RMSBean findBean = new RMSBean();
                    findBean.setReplyToEPR(toEPR.getAddress());
                    findBean.setTerminationPauserForCS(true);
                    RMSBean rmsBean = storageManager.getRMSBeanMgr().findUnique(findBean);
                    if (rmsBean != null) {
                        MessageContext requestSideRefMessage = storageManager.retrieveMessageContext(rmsBean.getReferenceMessageStoreKey(), context);
                        if (requestSideRefMessage == null) {
                            FaultManager.makeCreateSequenceRefusedFault(createSeqRMMsg, SandeshaMessageHelper.getMessage("referencedMessageNotFound", rmsBean.getInternalSequenceID()), new Exception());
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Exit: CreateSeqMsgProcessor::processInMessage " + Boolean.FALSE));
                            }
                            return false;
                        }
                        RMMsgContext requestSideRefRMMessage = MsgInitializer.initializeMessage(requestSideRefMessage);
                        TerminateManager.addTerminateSequenceMessage(requestSideRefRMMessage, rmsBean.getInternalSequenceID(), rmsBean.getSequenceID(), storageManager);
                    }
                }
                MessageContext outMessage = null;
                RMDBean rmdBean = SequenceManager.setupNewSequence(createSeqRMMsg, storageManager, secManager, token);
                RMMsgContext createSeqResponse = RMMsgCreator.createCreateSeqResponseMsg(createSeqRMMsg, rmdBean);
                outMessage = createSeqResponse.getMessageContext();
                outMessage.setMessageID(SandeshaUtil.getUUID());
                createSeqResponse.setFlow(2);
                createSeqResponse.setProperty("Sandesha2AppProcessingDone", "true");
                CreateSequenceResponse createSeqResPart = (CreateSequenceResponse)createSeqResponse.getMessagePart(10);
                SequenceOffer offer = createSeqPart.getSequenceOffer();
                if (offer != null) {
                    Accept accept = createSeqResPart.getAccept();
                    if (accept == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)SandeshaMessageHelper.getMessage("noAcceptPart"));
                        }
                        FaultManager.makeCreateSequenceRefusedFault(createSeqRMMsg, SandeshaMessageHelper.getMessage("noAcceptPart"), new Exception());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Exit: CreateSeqMsgProcessor::processInMessage " + Boolean.FALSE));
                        }
                        return false;
                    }
                    String offeredSequenceID = offer.getIdentifer().getIdentifier();
                    boolean offerEcepted = this.offerAccepted(offeredSequenceID, context, createSeqRMMsg, storageManager);
                    if (offerEcepted) {
                        RMSBean rMSBean = new RMSBean();
                        rMSBean.setSequenceID(offeredSequenceID);
                        String outgoingSideInternalSequenceId = SandeshaUtil.getOutgoingSideInternalSequenceID(rmdBean.getSequenceID());
                        rMSBean.setInternalSequenceID(outgoingSideInternalSequenceId);
                        rMSBean.setCreateSeqMsgID(SandeshaUtil.getUUID());
                        rMSBean.setToEPR(rmdBean.getToEPR());
                        rMSBean.setAcksToEPR(rmdBean.getToEPR());
                        rMSBean.setReplyToEPR(rmdBean.getReplyToEPR());
                        rMSBean.setLastActivatedTime(System.currentTimeMillis());
                        rMSBean.setRMVersion(rmdBean.getRMVersion());
                        rMSBean.setClientCompletedMessages(new RangeString());
                        Endpoint endpoint = offer.getEndpoint();
                        if (endpoint != null) {
                            rMSBean.setOfferedEndPoint(endpoint.getEPR().getAddress());
                        }
                        rmdBean.setOutboundInternalSequence(outgoingSideInternalSequenceId);
                        RMDBeanMgr rmdBeanMgr = storageManager.getRMDBeanMgr();
                        rmdBeanMgr.update(rmdBean);
                        rMSBean.setSecurityTokenData(rmdBean.getSecurityTokenData());
                        String acksTo = rMSBean.getAcksToEPR();
                        EndpointReference reference = new EndpointReference(acksTo);
                        if ((acksTo == null || reference.hasAnonymousAddress()) && "Spec_2007_02".equals(createSeqRMMsg.getRMSpecVersion())) {
                            rMSBean.setPollingMode(true);
                        }
                        rMSBean.setSoapVersion(SandeshaUtil.getSOAPVersion(createSeqRMMsg.getSOAPEnvelope()));
                        if (this.isReplayModel(createSeqRMMsg)) {
                            rMSBean.setReplayModel(true);
                            rmdBean.setReplayModel(true);
                        }
                        storageManager.getRMSBeanMgr().insert(rMSBean);
                        SandeshaUtil.startWorkersForSequence(context, rMSBean);
                    } else {
                        createSeqResPart.setAccept(null);
                        createSeqResponse.addSOAPEnvelope();
                    }
                }
                outMessage.setResponseWritten(true);
                rmdBean.setLastActivatedTime(System.currentTimeMillis());
                if (toEPR.hasAnonymousAddress() && "Spec_2007_02".equals(createSeqRMMsg.getRMSpecVersion())) {
                    rmdBean.setPollingMode(true);
                }
                storageManager.getRMDBeanMgr().update(rmdBean);
                SandeshaUtil.startWorkersForSequence(context, rmdBean);
                try {
                    AxisEngine.send((MessageContext)outMessage);
                }
                catch (AxisFault e) {
                    FaultManager.makeCreateSequenceRefusedFault(createSeqRMMsg, SandeshaMessageHelper.getMessage("couldNotSendCreateSeqResponse", SandeshaUtil.getStackTraceFromException((Exception)((Object)e))), (Exception)((Object)e));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exit: CreateSeqMsgProcessor::processInMessage " + Boolean.FALSE));
                    }
                    return false;
                }
                if (transaction != null && transaction.isActive()) {
                    transaction.commit();
                }
                if ((replyTo = createSeqMsg.getReplyTo()) == null || replyTo.hasAnonymousAddress()) {
                    TransportUtils.setResponseWritten((MessageContext)createSeqMsg, (boolean)true);
                }
                createSeqRMMsg.pause();
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Caught an exception processing CreateSequence message", (Throwable)e);
                }
                if (createSeqRMMsg.getMessageContext().getProperty("Code") == null && createSeqRMMsg.getMessageContext().getProperty("faultcode") == null) {
                    FaultManager.makeCreateSequenceRefusedFault(createSeqRMMsg, SandeshaUtil.getStackTraceFromException(e), e);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exit: CreateSeqMsgProcessor::processInMessage " + Boolean.FALSE));
                    }
                    return false;
                }
                if (createSeqRMMsg.getMessageContext().getProperty("Code") == null) break block31;
                if (e instanceof AxisFault) {
                    throw (AxisFault)((Object)e);
                }
                throw new SandeshaException(e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: CreateSeqMsgProcessor::processInMessage " + Boolean.TRUE));
        }
        return true;
    }

    private boolean offerAccepted(String sequenceId, ConfigurationContext configCtx, RMMsgContext createSeqRMMsg, StorageManager storageManager) throws SandeshaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: CreateSeqMsgProcessor::offerAccepted, " + sequenceId));
        }
        if ("".equals(sequenceId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: CreateSeqMsgProcessor::offerAccepted, false");
            }
            return false;
        }
        RMSBean createSeqFindBean = new RMSBean();
        createSeqFindBean.setSequenceID(sequenceId);
        List arr = storageManager.getRMSBeanMgr().find(createSeqFindBean);
        if (arr.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: CreateSeqMsgProcessor::offerAccepted, false");
            }
            return false;
        }
        if (sequenceId.length() <= 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: CreateSeqMsgProcessor::offerAccepted, false");
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: CreateSeqMsgProcessor::offerAccepted, true");
        }
        return true;
    }

    public boolean processOutMessage(RMMsgContext rmMsgCtx) {
        OperationContext operationContext;
        MessageContext msgCtx;
        SandeshaListener faultCallback;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: CreateSeqMsgProcessor::processOutMessage");
        }
        if ((faultCallback = (SandeshaListener)(msgCtx = rmMsgCtx.getMessageContext()).getOptions().getProperty(SandeshaClientConstants.SANDESHA_LISTENER)) != null && (operationContext = msgCtx.getOperationContext()) != null) {
            operationContext.setProperty(SandeshaClientConstants.SANDESHA_LISTENER, (Object)faultCallback);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: CreateSeqMsgProcessor::processOutMessage " + Boolean.FALSE));
        }
        return false;
    }

    private boolean isReplayModel(RMMsgContext createSequenceMessage) throws SandeshaException {
        boolean replayModel = false;
        CreateSequence createSequence = (CreateSequence)createSequenceMessage.getMessagePart(9);
        SequenceOffer offer = createSequence.getSequenceOffer();
        EndpointReference replyTo = createSequenceMessage.getReplyTo();
        String rmSpecVersion = createSequenceMessage.getRMSpecVersion();
        if (offer != null && replyTo != null && replyTo.hasAnonymousAddress() && rmSpecVersion != null && rmSpecVersion.equals("Spec_2005_02")) {
            replayModel = true;
        }
        return replayModel;
    }
}

