/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.assertj;

import org.springframework.lang.Nullable;
import org.springframework.test.http.HttpMessageContentConverter;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.assertj.MvcTestResult;
import org.springframework.test.web.servlet.assertj.MvcTestResultAssert;

final class DefaultMvcTestResult
implements MvcTestResult {
    @Nullable
    private final MvcResult mvcResult;
    @Nullable
    private final Exception unresolvedException;
    @Nullable
    private final HttpMessageContentConverter contentConverter;

    DefaultMvcTestResult(@Nullable MvcResult mvcResult, @Nullable Exception unresolvedException, @Nullable HttpMessageContentConverter contentConverter) {
        this.mvcResult = mvcResult;
        this.unresolvedException = unresolvedException;
        this.contentConverter = contentConverter;
    }

    @Override
    public MvcResult getMvcResult() {
        if (this.mvcResult == null) {
            throw new IllegalStateException("Request failed with unresolved exception " + String.valueOf(this.unresolvedException));
        }
        return this.mvcResult;
    }

    @Override
    @Nullable
    public Exception getUnresolvedException() {
        return this.unresolvedException;
    }

    @Nullable
    public Exception getResolvedException() {
        return this.getMvcResult().getResolvedException();
    }

    public MvcTestResultAssert assertThat() {
        return new MvcTestResultAssert(this, this.contentConverter);
    }
}

