/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.web.socket;

import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.lang.Nullable;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.util.ClassUtils;

class MockServerContainerContextCustomizerFactory
implements ContextCustomizerFactory {
    private static final String MOCK_SERVER_CONTAINER_CONTEXT_CUSTOMIZER_CLASS_NAME = "org.springframework.test.context.web.socket.MockServerContainerContextCustomizer";
    private static final boolean webSocketPresent = ClassUtils.isPresent((String)"javax.websocket.server.ServerContainer", (ClassLoader)MockServerContainerContextCustomizerFactory.class.getClassLoader());

    MockServerContainerContextCustomizerFactory() {
    }

    @Override
    @Nullable
    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        if (webSocketPresent && MockServerContainerContextCustomizerFactory.isAnnotatedWithWebAppConfiguration(testClass)) {
            try {
                Class clazz = ClassUtils.forName((String)MOCK_SERVER_CONTAINER_CONTEXT_CUSTOMIZER_CLASS_NAME, (ClassLoader)this.getClass().getClassLoader());
                return (ContextCustomizer)BeanUtils.instantiateClass((Class)clazz);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to enable WebSocket test support; could not load class: org.springframework.test.context.web.socket.MockServerContainerContextCustomizer", ex);
            }
        }
        return null;
    }

    private static boolean isAnnotatedWithWebAppConfiguration(Class<?> testClass) {
        return TestContextAnnotationUtils.hasAnnotation(testClass, WebAppConfiguration.class);
    }
}

