/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval;

import java.util.List;
import java.util.Map;
import net.sf.oval.CheckExclusion;
import net.sf.oval.Validator;
import net.sf.oval.expression.ExpressionLanguage;
import net.sf.oval.internal.util.StringUtils;

public abstract class AbstractCheckExclusion
implements CheckExclusion {
    private static final long serialVersionUID = 1L;
    private String[] profiles;
    private String when;
    private String whenFormula;
    private String whenLang;

    public Map<String, String> getMessageVariables() {
        return null;
    }

    @Override
    public String[] getProfiles() {
        return this.profiles;
    }

    @Override
    public String getWhen() {
        return String.valueOf(this.whenLang) + ":" + this.when;
    }

    @Override
    public boolean isActive(Object validatedObject, Object valueToValidate, Validator validator) {
        if (this.when == null) {
            return true;
        }
        Map values = Validator.getCollectionFactory().createMap();
        values.put("_value", valueToValidate);
        values.put("_this", validatedObject);
        ExpressionLanguage el = validator.getExpressionLanguageRegistry().getExpressionLanguage(this.whenLang);
        return el.evaluateAsBoolean(this.whenFormula, values);
    }

    @Override
    public void setProfiles(String ... profiles) {
        this.profiles = profiles;
    }

    @Override
    public void setWhen(String when) {
        if (when == null || when.length() == 0) {
            this.when = null;
            this.whenFormula = null;
            this.whenLang = null;
        } else {
            List<String> parts = StringUtils.split(when, ':', 2);
            if (parts.size() < 2) {
                throw new IllegalArgumentException("[when] is missing the scripting language declaration");
            }
            this.when = when;
            this.whenLang = parts.get(0);
            this.whenFormula = parts.get(1);
        }
    }
}

