/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.Bundle;

public class OsgiUtil {
    private static final Logger LOG = LogManager.getLogger(OsgiUtil.class);

    public static URL translateBundleURLToJarURL(URL bundleUrl, Bundle bundle) throws MalformedURLException {
        if (bundleUrl != null && "bundle".equalsIgnoreCase(bundleUrl.getProtocol())) {
            StringBuilder sb = new StringBuilder("jar:");
            sb.append(bundle.getLocation());
            sb.append("!");
            sb.append(bundleUrl.getFile());
            return new URL(sb.toString());
        }
        return bundleUrl;
    }

    public static Object getBean(Object beanFactory, String beanId) {
        try {
            Method getBeanMethod = beanFactory.getClass().getMethod("getBean", String.class);
            return getBeanMethod.invoke(beanFactory, beanId);
        }
        catch (Exception ex) {
            LOG.error("Unable to call getBean() on object of type [{}], with bean id [{}]", (Object)beanFactory.getClass().getName(), (Object)beanId, (Object)ex);
            return null;
        }
    }

    public static boolean containsBean(Object beanFactory, String beanId) {
        try {
            Method getBeanMethod = beanFactory.getClass().getMethod("containsBean", String.class);
            return (Boolean)getBeanMethod.invoke(beanFactory, beanId);
        }
        catch (Exception ex) {
            LOG.error("Unable to call containsBean() on object of type [{}], with bean id [{}]", (Object)beanFactory.getClass().getName(), (Object)beanId, (Object)ex);
            return false;
        }
    }

    public static String generateJavaVersionForSystemPackages(String systemJavaVersion) {
        String parsedResult;
        int dotIndex2;
        if (systemJavaVersion == null || systemJavaVersion.isEmpty()) {
            throw new IllegalArgumentException("Cannot parse Java version from null or empty string");
        }
        int dotIndex1 = systemJavaVersion.indexOf(46);
        int n = dotIndex2 = dotIndex1 > 0 ? systemJavaVersion.indexOf(46, dotIndex1 + 1) : -1;
        if (dotIndex1 > 0 && dotIndex2 > 0) {
            parsedResult = systemJavaVersion.substring(0, dotIndex2);
        } else if (dotIndex1 > 0) {
            parsedResult = systemJavaVersion;
        } else if (dotIndex1 == -1) {
            int minusIndex = systemJavaVersion.indexOf(45);
            int plusIndex = systemJavaVersion.indexOf(43);
            parsedResult = minusIndex > 0 ? systemJavaVersion.substring(0, minusIndex) : (plusIndex > 0 ? systemJavaVersion.substring(0, plusIndex) : systemJavaVersion);
            try {
                int firstNumber = Integer.parseInt(parsedResult);
                if (firstNumber < 9) {
                    throw new IllegalArgumentException("Single digit Java version string less than 9 (nonsense)");
                }
                parsedResult = parsedResult + ".0";
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Cannot parse Java version string (probable non-numeric start)", ex);
            }
        } else {
            throw new IllegalArgumentException("Cannot parse Java version from a string starting with a '.'");
        }
        return parsedResult;
    }

    public static String generateJava_SE_SystemPackageVersionString(String systemJavaVersion) {
        String javaVersionForSystemPackages = OsgiUtil.generateJavaVersionForSystemPackages(systemJavaVersion);
        int dotIndex = javaVersionForSystemPackages.indexOf(46);
        if (dotIndex > 0) {
            try {
                String prefix = javaVersionForSystemPackages.substring(0, dotIndex);
                String suffix = javaVersionForSystemPackages.substring(dotIndex + 1);
                int firstNumber = Integer.parseInt(prefix);
                int secondNumber = Integer.parseInt(suffix);
                String generatedResult = firstNumber >= 9 ? String.format("0.0.0.JavaSE_%03d", firstNumber) : String.format("0.0.0.JavaSE_001_%03d", secondNumber);
                return generatedResult;
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Cannot parse Java version string (probable non-numeric start)", ex);
            }
        }
        throw new IllegalArgumentException("Cannot parse Java version from a system packages string missing or starting with a '.'");
    }
}

