/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.servicedir;

import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.com.google.common.collect.ImmutableSet;
import com.google.gxp.com.google.common.collect.Maps;
import com.google.gxp.com.google.common.collect.Sets;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.base.Callable;
import com.google.gxp.compiler.base.ClassImport;
import com.google.gxp.compiler.base.DefaultingImportVisitor;
import com.google.gxp.compiler.base.Implementable;
import com.google.gxp.compiler.base.Import;
import com.google.gxp.compiler.base.InstanceCallable;
import com.google.gxp.compiler.base.PackageImport;
import com.google.gxp.compiler.base.TemplateName;
import com.google.gxp.compiler.servicedir.AmbiguousImportError;
import com.google.gxp.compiler.servicedir.ServiceDirectory;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ScopedServiceDirectory
implements ServiceDirectory {
    private final String packageName;
    private final Set<String> packageImports;
    private final Map<String, TemplateName> classImports;
    private final ServiceDirectory baseServiceDirectory;
    private final Function<TemplateName, Callable> callableGetter = new Function<TemplateName, Callable>(){

        @Override
        public Callable apply(TemplateName from) {
            return ScopedServiceDirectory.this.baseServiceDirectory.getCallable(from);
        }
    };
    private final Function<TemplateName, InstanceCallable> instanceCallableGetter = new Function<TemplateName, InstanceCallable>(){

        @Override
        public InstanceCallable apply(TemplateName from) {
            return ScopedServiceDirectory.this.baseServiceDirectory.getInstanceCallable(from);
        }
    };
    private final Function<TemplateName, Implementable> implementableGetter = new Function<TemplateName, Implementable>(){

        @Override
        public Implementable apply(TemplateName from) {
            return ScopedServiceDirectory.this.baseServiceDirectory.getImplementable(from);
        }
    };

    public ScopedServiceDirectory(AlertSink alertSink, ServiceDirectory baseServiceDirectory, String packageName, List<? extends Import> imports) {
        this.baseServiceDirectory = Preconditions.checkNotNull(baseServiceDirectory);
        this.packageName = Preconditions.checkNotNull(packageName);
        ImportProcessor visitor = new ImportProcessor(alertSink, packageName);
        for (Import import_ : imports) {
            import_.acceptVisitor(visitor);
        }
        this.packageImports = ImmutableSet.copyOf(visitor.getPackageImports());
        this.classImports = ImmutableMap.copyOf(visitor.getClassImports());
    }

    private <T> T baseGet(TemplateName templateName, Function<TemplateName, T> underlyingGetter) {
        if (templateName.getPackageName() == null) {
            String baseName = templateName.getBaseName();
            if (this.classImports.containsKey(baseName)) {
                return underlyingGetter.apply(this.classImports.get(baseName));
            }
            templateName = this.baseFindUniquePackageMatch(baseName, underlyingGetter);
            if (templateName == null) {
                templateName = TemplateName.create(this.packageName, baseName);
            }
        }
        return underlyingGetter.apply(templateName);
    }

    private <T> TemplateName baseFindUniquePackageMatch(String baseName, Function<TemplateName, T> underlyingGetter) {
        TemplateName.FullyQualified result = null;
        for (String packageImport : this.packageImports) {
            TemplateName.FullyQualified fqName = new TemplateName.FullyQualified(packageImport, baseName);
            if (underlyingGetter.apply(fqName) == null) continue;
            if (result != null) {
                return null;
            }
            result = fqName;
        }
        return result;
    }

    @Override
    public Callable getCallable(TemplateName templateName) {
        return this.baseGet(templateName, this.callableGetter);
    }

    @Override
    public InstanceCallable getInstanceCallable(TemplateName templateName) {
        return this.baseGet(templateName, this.instanceCallableGetter);
    }

    @Override
    public Implementable getImplementable(TemplateName templateName) {
        return this.baseGet(templateName, this.implementableGetter);
    }

    private static class ImportProcessor
    extends DefaultingImportVisitor<Void> {
        private final AlertSink alertSink;
        private final Set<String> packageImports = Sets.newHashSet();
        private final Map<String, TemplateName> classImports = Maps.newHashMap();

        public ImportProcessor(AlertSink alertSink, String packageName) {
            this.alertSink = Preconditions.checkNotNull(alertSink);
            this.packageImports.add(packageName);
        }

        public Set<String> getPackageImports() {
            return this.packageImports;
        }

        public Map<String, TemplateName> getClassImports() {
            return this.classImports;
        }

        @Override
        public Void defaultVisitImport(Import imp) {
            return null;
        }

        @Override
        public Void visitClassImport(ClassImport imp) {
            TemplateName.FullyQualified className = imp.getClassName();
            String baseName = className.getBaseName();
            TemplateName redundantImport = this.classImports.get(baseName);
            if (redundantImport != null && !className.equals(redundantImport)) {
                this.alertSink.add(new AmbiguousImportError(imp, baseName, redundantImport, className));
            } else {
                this.classImports.put(baseName, className);
            }
            return null;
        }

        @Override
        public Void visitPackageImport(PackageImport imp) {
            this.packageImports.add(imp.getPackageName());
            return null;
        }
    }
}

