/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler;

import com.google.gxp.com.google.common.base.Charsets;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.base.Predicate;
import com.google.gxp.com.google.common.base.Predicates;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.com.google.common.collect.Sets;
import com.google.gxp.compiler.CompilationManager;
import com.google.gxp.compiler.CompilationTask;
import com.google.gxp.compiler.CompilationUnit;
import com.google.gxp.compiler.alerts.AlertPolicy;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.alerts.common.IOError;
import com.google.gxp.compiler.alerts.common.ProgressAlert;
import com.google.gxp.compiler.base.ExtractedMessage;
import com.google.gxp.compiler.base.OutputLanguage;
import com.google.gxp.compiler.base.TemplateName;
import com.google.gxp.compiler.base.Util;
import com.google.gxp.compiler.codegen.CodeGeneratorFactory;
import com.google.gxp.compiler.fs.FileRef;
import com.google.gxp.compiler.parser.Parser;
import com.google.gxp.compiler.servicedir.OnDemandServiceDirectory;
import com.google.gxp.compiler.servicedir.ServiceDirectory;
import com.google.transconsole.common.messages.MessageBundle;
import com.google.transconsole.common.messages.PropertiesBundleWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.UnmappableCharacterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CompilationSet {
    private final Map<TemplateName.FullyQualified, CompilationUnit> compilationUnits;
    private final Parser parser;
    private final CodeGeneratorFactory codeGeneratorFactory;
    private final CompilationManager manager;
    private final ServiceDirectory serviceDirectory;
    private final long compilationVersion;
    private final FileRef propertiesFile;

    private CompilationSet(Builder builder, Iterable<FileRef> inputFileRefs) {
        this.parser = builder.parser;
        this.codeGeneratorFactory = builder.codeGeneratorFactory;
        this.manager = builder.manager;
        this.compilationVersion = builder.compilationVersion;
        this.propertiesFile = builder.propertiesFile;
        this.serviceDirectory = new OnDemandServiceDirectory(this);
        this.compilationUnits = this.createCompilationUnits(this.serviceDirectory, inputFileRefs);
    }

    private Map<TemplateName.FullyQualified, CompilationUnit> createCompilationUnits(ServiceDirectory serviceDirectory, Iterable<FileRef> inputFileRefs) {
        ImmutableMap.Builder<TemplateName.FullyQualified, CompilationUnit> mapBuilder = ImmutableMap.builder();
        for (FileRef inputFileRef : inputFileRefs) {
            CompilationUnit unit = new CompilationUnit(serviceDirectory, this.parser, inputFileRef, this.compilationVersion);
            mapBuilder.put(unit.getTemplateName(), unit);
        }
        return mapBuilder.build();
    }

    public final List<CompilationUnit> getCompilationUnits() {
        return ImmutableList.copyOf(this.compilationUnits.values());
    }

    public final CompilationUnit getCompilationUnit(TemplateName.FullyQualified templateName) {
        return this.compilationUnits.get(templateName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(AlertSink alertSink, AlertPolicy alertPolicy, Iterable<OutputLanguage> outputLanguages, Predicate<FileRef> allowedOutputPredicate) {
        SourcePosition sourcePosition;
        FileRef sourceFileRef;
        HashSet<CompilationUnit> extractMessagesFrom = Sets.newHashSet();
        ArrayList<CompilationTask> sourceNotChanged = Lists.newArrayList();
        for (CompilationUnit cUnit : this.getCompilationUnits()) {
            sourceFileRef = cUnit.getSourceFileRef();
            sourcePosition = new SourcePosition(sourceFileRef);
            for (OutputLanguage language : outputLanguages) {
                FileRef outputFileRef;
                String suffix = language.getSuffix();
                if (language.suffixIncludesVersion()) {
                    suffix = String.format(suffix, this.compilationVersion);
                }
                if (allowedOutputPredicate.apply(outputFileRef = sourceFileRef.removeExtension().addSuffix(suffix))) {
                    extractMessagesFrom.add(cUnit);
                    CompilationTask task = new CompilationTask(cUnit, this.codeGeneratorFactory, language, outputFileRef);
                    if (outputFileRef.getLastModified() < sourceFileRef.getLastModified() || this.manager.sourceChanged(task)) {
                        task.execute(alertSink, alertPolicy);
                        continue;
                    }
                    alertSink.add(new ProgressAlert(sourcePosition, "Skipped (source unchanged)"));
                    sourceNotChanged.add(task);
                    continue;
                }
                alertSink.add(new ProgressAlert(sourcePosition, "Skipped (output supressed)"));
            }
        }
        for (CompilationTask task : sourceNotChanged) {
            if (!this.manager.usedInterfacesChanged(task)) continue;
            sourceFileRef = task.getCompilationUnit().getSourceFileRef();
            sourcePosition = new SourcePosition(sourceFileRef);
            alertSink.add(new ProgressAlert(sourcePosition, "Reconsidered; callees have changed"));
            task.execute(alertSink, alertPolicy);
        }
        if (this.propertiesFile != null && !extractMessagesFrom.isEmpty()) {
            SourcePosition outputPosition = new SourcePosition(this.propertiesFile);
            alertSink.add(new ProgressAlert(outputPosition, "Generating"));
            ArrayList<ExtractedMessage> messages = Lists.newArrayList();
            for (CompilationUnit cUnit : extractMessagesFrom) {
                messages.addAll(cUnit.getMessageExtractedTree().getMessages());
            }
            MessageBundle messageBundle = Util.bundleMessages(alertSink, messages);
            PropertiesBundleWriter pbw = new PropertiesBundleWriter(messageBundle);
            try {
                Writer writer = this.propertiesFile.openWriter(Charsets.US_ASCII);
                try {
                    pbw.write(writer);
                }
                finally {
                    writer.close();
                }
            }
            catch (UnmappableCharacterException uce) {
                throw new AssertionError((Object)uce);
            }
            catch (IOException iox) {
                alertSink.add(new IOError(this.propertiesFile, iox));
            }
            alertSink.add(new ProgressAlert(outputPosition, "Generate finished"));
        }
    }

    public final void compile(AlertSink alertSink, AlertPolicy alertPolicy, Iterable<OutputLanguage> outputLanguages) {
        this.compile(alertSink, alertPolicy, outputLanguages, Predicates.<FileRef>alwaysTrue());
    }

    public static final class Builder {
        private final Parser parser;
        private final CodeGeneratorFactory codeGeneratorFactory;
        private final CompilationManager manager;
        private long compilationVersion = 0L;
        private FileRef propertiesFile = null;

        public Builder(Parser parser, CodeGeneratorFactory codeGeneratorFactory, CompilationManager manager) {
            this.parser = Preconditions.checkNotNull(parser);
            this.codeGeneratorFactory = Preconditions.checkNotNull(codeGeneratorFactory);
            this.manager = Preconditions.checkNotNull(manager);
        }

        public CompilationSet build(Iterable<FileRef> inputFileRefs) {
            return new CompilationSet(this, inputFileRefs);
        }

        public CompilationSet build(FileRef ... inputFileRefs) {
            return this.build(Arrays.asList(inputFileRefs));
        }

        public Builder setCompilationVersion(long compilationVersion) {
            this.compilationVersion = compilationVersion;
            return this;
        }

        public Builder setPropertiesFile(FileRef propertiesFile) {
            this.propertiesFile = propertiesFile;
            return this;
        }
    }
}

