/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.impl;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.felix.shell.impl.PsCommandImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;

public class FindCommandImpl
extends PsCommandImpl {
    static /* synthetic */ Class class$org$osgi$service$startlevel$StartLevel;

    public FindCommandImpl(BundleContext context) {
        super(context);
    }

    public void execute(String line, PrintStream out, PrintStream err) {
        StringTokenizer st = new StringTokenizer(line);
        if (st.countTokens() < 2) {
            out.println("Please specify a bundle name");
            return;
        }
        ServiceReference ref = this.m_context.getServiceReference((class$org$osgi$service$startlevel$StartLevel == null ? (class$org$osgi$service$startlevel$StartLevel = FindCommandImpl.class$("org.osgi.service.startlevel.StartLevel")) : class$org$osgi$service$startlevel$StartLevel).getName());
        StartLevel sl = null;
        if (ref != null) {
            sl = (StartLevel)this.m_context.getService(ref);
        }
        if (sl == null) {
            out.println("StartLevel service is unavailable.");
        }
        st.nextToken();
        String pattern = st.nextToken();
        Bundle[] bundles = this.m_context.getBundles();
        ArrayList<Bundle> found = new ArrayList<Bundle>();
        for (int i = 0; i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            String name = (String)bundle.getHeaders().get("Bundle-Name");
            if (!this.match(bundle.getSymbolicName(), pattern) && !this.match(name, pattern)) continue;
            found.add(bundle);
        }
        if (found.size() > 0) {
            this.printBundleList(found.toArray(new Bundle[found.size()]), sl, out, false, false, false);
        } else {
            out.println("No matching bundles found");
        }
    }

    private boolean match(String name, String pattern) {
        return name != null && name.toLowerCase().contains(pattern.toLowerCase());
    }

    public String getName() {
        return "find";
    }

    public String getShortDescription() {
        return "find bundles by name.";
    }

    public String getUsage() {
        return "find <bundle name>";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

