/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.js;

import com.google.gxp.base.GxpContext;
import com.google.gxp.com.google.common.base.CharEscapers;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.js.JavascriptClosure;
import com.google.i18n.Localizable;
import java.io.IOException;
import java.io.StringWriter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JavascriptAppender {
    public static final JavascriptAppender INSTANCE = new JavascriptAppender();

    protected JavascriptAppender() {
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, byte value) throws IOException {
        out.append(String.valueOf(value));
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, short value) throws IOException {
        out.append(String.valueOf(value));
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, int value) throws IOException {
        out.append(String.valueOf(value));
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, long value) throws IOException {
        out.append(String.valueOf(value));
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, float value) throws IOException {
        out.append(String.valueOf(value));
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, double value) throws IOException {
        out.append(String.valueOf(value));
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, char value) throws IOException {
        out.append('\"');
        CharEscapers.javascriptEscaper().escape(out).append(value);
        out.append('\"');
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, boolean value) throws IOException {
        out.append(String.valueOf(value));
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, JavascriptClosure closure) throws IOException {
        Preconditions.checkNotNull(closure);
        closure.write(out, gxpContext);
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, JSONArray value) throws IOException {
        Preconditions.checkNotNull(value);
        StringWriter sw = new StringWriter();
        try {
            value.write(sw);
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
        out.append(sw.toString());
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, JSONObject value) throws IOException {
        Preconditions.checkNotNull(value);
        StringWriter sw = new StringWriter();
        try {
            value.write(sw);
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
        out.append(sw.toString());
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, CharSequence value) throws IOException {
        if (value == null) {
            out.append("null");
        } else {
            out.append('\"');
            CharEscapers.javascriptEscaper().escape(out).append(value);
            out.append('\"');
        }
        return out;
    }

    public <A extends Appendable> A append(A out, GxpContext gxpContext, Localizable value) throws IOException {
        Preconditions.checkNotNull(value);
        return this.append(out, gxpContext, value.toString(gxpContext.getLocale()));
    }
}

