/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.ognl;

import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.conversion.impl.XWorkConverter;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.ognl.BeanInfoCacheFactory;
import com.opensymphony.xwork2.ognl.DefaultOgnlBeanInfoCacheFactory;
import com.opensymphony.xwork2.ognl.DefaultOgnlExpressionCacheFactory;
import com.opensymphony.xwork2.ognl.ExpressionCacheFactory;
import com.opensymphony.xwork2.ognl.OgnlCache;
import com.opensymphony.xwork2.ognl.OgnlTypeConverterWrapper;
import com.opensymphony.xwork2.ognl.SecurityMemberAccess;
import com.opensymphony.xwork2.ognl.accessor.CompoundRootAccessor;
import com.opensymphony.xwork2.util.CompoundRoot;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.reflection.ReflectionException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import ognl.ClassResolver;
import ognl.MemberAccess;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.SimpleNode;
import ognl.TypeConverter;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OgnlUtil {
    private static final Logger LOG = LogManager.getLogger(OgnlUtil.class);
    private final AtomicBoolean warnReported = new AtomicBoolean(false);
    private final OgnlCache<String, Object> expressionCache;
    private final OgnlCache<Class<?>, BeanInfo> beanInfoCache;
    private TypeConverter defaultConverter;
    private boolean devMode;
    private boolean enableExpressionCache = true;
    private boolean enableEvalExpression;
    private Set<Class<?>> excludedClasses;
    private Set<Pattern> excludedPackageNamePatterns;
    private Set<String> excludedPackageNames;
    private Set<Class<?>> devModeExcludedClasses;
    private Set<Pattern> devModeExcludedPackageNamePatterns;
    private Set<String> devModeExcludedPackageNames;
    private Container container;
    private boolean allowStaticFieldAccess = true;
    private boolean disallowProxyMemberAccess;

    @Deprecated
    public OgnlUtil() {
        this(new DefaultOgnlExpressionCacheFactory<String, Object>(), new DefaultOgnlBeanInfoCacheFactory());
    }

    @Inject
    public OgnlUtil(@Inject ExpressionCacheFactory<String, Object> ognlExpressionCacheFactory, @Inject BeanInfoCacheFactory<Class<?>, BeanInfo> ognlBeanInfoCacheFactory) {
        if (ognlExpressionCacheFactory == null) {
            throw new IllegalArgumentException("ExpressionCacheFactory parameter cannot be null");
        }
        if (ognlBeanInfoCacheFactory == null) {
            throw new IllegalArgumentException("BeanInfoCacheFactory parameter cannot be null");
        }
        this.excludedClasses = Collections.unmodifiableSet(new HashSet());
        this.excludedPackageNamePatterns = Collections.unmodifiableSet(new HashSet());
        this.excludedPackageNames = Collections.unmodifiableSet(new HashSet());
        this.devModeExcludedClasses = Collections.unmodifiableSet(new HashSet());
        this.devModeExcludedPackageNamePatterns = Collections.unmodifiableSet(new HashSet());
        this.devModeExcludedPackageNames = Collections.unmodifiableSet(new HashSet());
        this.expressionCache = ognlExpressionCacheFactory.buildOgnlCache();
        this.beanInfoCache = ognlBeanInfoCacheFactory.buildOgnlCache();
    }

    @Inject
    protected void setXWorkConverter(XWorkConverter conv) {
        this.defaultConverter = new OgnlTypeConverterWrapper(conv);
    }

    @Inject(value="struts.devMode")
    protected void setDevMode(String mode) {
        this.devMode = BooleanUtils.toBoolean((String)mode);
    }

    @Inject(value="struts.ognl.enableExpressionCache")
    protected void setEnableExpressionCache(String cache) {
        this.enableExpressionCache = BooleanUtils.toBoolean((String)cache);
    }

    @Inject(value="struts.ognl.expressionCacheMaxSize", required=false)
    protected void setExpressionCacheMaxSize(String maxSize) {
        this.expressionCache.setEvictionLimit(Integer.parseInt(maxSize));
    }

    @Inject(value="struts.ognl.beanInfoCacheMaxSize", required=false)
    protected void setBeanInfoCacheMaxSize(String maxSize) {
        this.beanInfoCache.setEvictionLimit(Integer.parseInt(maxSize));
    }

    @Inject(value="struts.ognl.enableEvalExpression", required=false)
    protected void setEnableEvalExpression(String evalExpression) {
        this.enableEvalExpression = BooleanUtils.toBoolean((String)evalExpression);
        if (this.enableEvalExpression) {
            LOG.warn("Enabling OGNL expression evaluation may introduce security risks (see http://struts.apache.org/release/2.3.x/docs/s2-013.html for further details)");
        }
    }

    @Inject(value="struts.excludedClasses", required=false)
    protected void setExcludedClasses(String commaDelimitedClasses) {
        HashSet excludedClasses = new HashSet();
        excludedClasses.addAll(this.excludedClasses);
        excludedClasses.addAll(this.parseExcludedClasses(commaDelimitedClasses));
        this.excludedClasses = Collections.unmodifiableSet(excludedClasses);
    }

    @Inject(value="struts.devMode.excludedClasses", required=false)
    protected void setDevModeExcludedClasses(String commaDelimitedClasses) {
        HashSet excludedClasses = new HashSet();
        excludedClasses.addAll(this.devModeExcludedClasses);
        excludedClasses.addAll(this.parseExcludedClasses(commaDelimitedClasses));
        this.devModeExcludedClasses = Collections.unmodifiableSet(excludedClasses);
    }

    private Set<Class<?>> parseExcludedClasses(String commaDelimitedClasses) {
        Set<String> classNames = TextParseUtil.commaDelimitedStringToSet(commaDelimitedClasses);
        HashSet classes = new HashSet();
        for (String className : classNames) {
            try {
                classes.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Cannot load excluded class: " + className, e);
            }
        }
        return classes;
    }

    @Inject(value="struts.excludedPackageNamePatterns", required=false)
    protected void setExcludedPackageNamePatterns(String commaDelimitedPackagePatterns) {
        HashSet<Pattern> excludedPackageNamePatterns = new HashSet<Pattern>();
        excludedPackageNamePatterns.addAll(this.excludedPackageNamePatterns);
        excludedPackageNamePatterns.addAll(this.parseExcludedPackageNamePatterns(commaDelimitedPackagePatterns));
        this.excludedPackageNamePatterns = Collections.unmodifiableSet(excludedPackageNamePatterns);
    }

    @Inject(value="struts.devMode.excludedPackageNamePatterns", required=false)
    protected void setDevModeExcludedPackageNamePatterns(String commaDelimitedPackagePatterns) {
        HashSet<Pattern> excludedPackageNamePatterns = new HashSet<Pattern>();
        excludedPackageNamePatterns.addAll(this.devModeExcludedPackageNamePatterns);
        excludedPackageNamePatterns.addAll(this.parseExcludedPackageNamePatterns(commaDelimitedPackagePatterns));
        this.devModeExcludedPackageNamePatterns = Collections.unmodifiableSet(excludedPackageNamePatterns);
    }

    private Set<Pattern> parseExcludedPackageNamePatterns(String commaDelimitedPackagePatterns) {
        Set<String> packagePatterns = TextParseUtil.commaDelimitedStringToSet(commaDelimitedPackagePatterns);
        HashSet<Pattern> packageNamePatterns = new HashSet<Pattern>();
        for (String pattern : packagePatterns) {
            packageNamePatterns.add(Pattern.compile(pattern));
        }
        return packageNamePatterns;
    }

    @Inject(value="struts.excludedPackageNames", required=false)
    protected void setExcludedPackageNames(String commaDelimitedPackageNames) {
        HashSet<String> excludedPackageNames = new HashSet<String>();
        excludedPackageNames.addAll(this.excludedPackageNames);
        excludedPackageNames.addAll(this.parseExcludedPackageNames(commaDelimitedPackageNames));
        this.excludedPackageNames = Collections.unmodifiableSet(excludedPackageNames);
    }

    @Inject(value="struts.devMode.excludedPackageNames", required=false)
    protected void setDevModeExcludedPackageNames(String commaDelimitedPackageNames) {
        HashSet<String> excludedPackageNames = new HashSet<String>();
        excludedPackageNames.addAll(this.devModeExcludedPackageNames);
        excludedPackageNames.addAll(this.parseExcludedPackageNames(commaDelimitedPackageNames));
        this.devModeExcludedPackageNames = Collections.unmodifiableSet(excludedPackageNames);
    }

    private Set<String> parseExcludedPackageNames(String commaDelimitedPackageNames) {
        return TextParseUtil.commaDelimitedStringToSet(commaDelimitedPackageNames);
    }

    public Set<Class<?>> getExcludedClasses() {
        return this.excludedClasses;
    }

    public Set<Pattern> getExcludedPackageNamePatterns() {
        return this.excludedPackageNamePatterns;
    }

    public Set<String> getExcludedPackageNames() {
        return this.excludedPackageNames;
    }

    @Inject
    protected void setContainer(Container container) {
        this.container = container;
    }

    @Inject(value="struts.ognl.allowStaticFieldAccess", required=false)
    protected void setAllowStaticFieldAccess(String allowStaticFieldAccess) {
        this.allowStaticFieldAccess = BooleanUtils.toBoolean((String)allowStaticFieldAccess);
    }

    @Inject(value="struts.disallowProxyMemberAccess", required=false)
    protected void setDisallowProxyMemberAccess(String disallowProxyMemberAccess) {
        this.disallowProxyMemberAccess = BooleanUtils.toBoolean((String)disallowProxyMemberAccess);
    }

    @Inject(value="struts.ognl.expressionMaxLength", required=false)
    protected void applyExpressionMaxLength(String maxLength) {
        try {
            if (maxLength == null || maxLength.isEmpty()) {
                Ognl.applyExpressionMaxLength(null);
                LOG.warn("OGNL Expression Max Length disabled.");
            } else {
                Ognl.applyExpressionMaxLength((Integer)Integer.parseInt(maxLength));
                LOG.debug("OGNL Expression Max Length enabled with {}.", (Object)maxLength);
            }
        }
        catch (Exception ex) {
            LOG.error("Unable to set OGNL Expression Max Length {}.", (Object)maxLength);
            throw ex;
        }
    }

    public boolean isDisallowProxyMemberAccess() {
        return this.disallowProxyMemberAccess;
    }

    public static void clearRuntimeCache() {
        OgnlRuntime.clearCache();
    }

    public void clearExpressionCache() {
        this.expressionCache.clear();
    }

    public int expressionCacheSize() {
        return this.expressionCache.size();
    }

    public void clearBeanInfoCache() {
        this.beanInfoCache.clear();
    }

    public int beanInfoCacheSize() {
        return this.beanInfoCache.size();
    }

    public void setProperties(Map<String, ?> props, Object o, Map<String, Object> context) {
        this.setProperties(props, o, context, false);
    }

    public void setProperties(Map<String, ?> props, Object o, Map<String, Object> context, boolean throwPropertyExceptions) throws ReflectionException {
        if (props == null) {
            return;
        }
        Object oldRoot = Ognl.getRoot(context);
        Ognl.setRoot(context, (Object)o);
        for (Map.Entry<String, ?> entry : props.entrySet()) {
            String expression = entry.getKey();
            this.internalSetProperty(expression, entry.getValue(), o, context, throwPropertyExceptions);
        }
        Ognl.setRoot(context, (Object)oldRoot);
    }

    public void setProperties(Map<String, ?> properties, Object o) {
        this.setProperties(properties, o, false);
    }

    public void setProperties(Map<String, ?> properties, Object o, boolean throwPropertyExceptions) {
        Map<String, Object> context = this.createDefaultContext(o);
        this.setProperties(properties, o, context, throwPropertyExceptions);
    }

    public void setProperty(String name, Object value, Object o, Map<String, Object> context) {
        this.setProperty(name, value, o, context, false);
    }

    public void setProperty(String name, Object value, Object o, Map<String, Object> context, boolean throwPropertyExceptions) {
        Object oldRoot = Ognl.getRoot(context);
        Ognl.setRoot(context, (Object)o);
        this.internalSetProperty(name, value, o, context, throwPropertyExceptions);
        Ognl.setRoot(context, (Object)oldRoot);
    }

    public Object getRealTarget(String property, Map<String, Object> context, Object root) throws OgnlException {
        if ("top".equals(property)) {
            return root;
        }
        if (root instanceof CompoundRoot) {
            CompoundRoot cr = (CompoundRoot)root;
            try {
                for (Object target : cr) {
                    if (!OgnlRuntime.hasSetProperty((OgnlContext)((OgnlContext)context), target, (Object)property) && !OgnlRuntime.hasGetProperty((OgnlContext)((OgnlContext)context), target, (Object)property) && OgnlRuntime.getIndexedPropertyType((OgnlContext)((OgnlContext)context), target.getClass(), (String)property) == OgnlRuntime.INDEXED_PROPERTY_NONE) continue;
                    return target;
                }
            }
            catch (IntrospectionException ex) {
                throw new ReflectionException("Cannot figure out real target class", ex);
            }
            return null;
        }
        return root;
    }

    public void setValue(String name, Map<String, Object> context, Object root, Object value) throws OgnlException {
        this.compileAndExecute(name, context, tree -> {
            if (this.isEvalExpression(tree, context)) {
                throw new OgnlException("Eval expression/chained expressions cannot be used as parameter name");
            }
            if (this.isArithmeticExpression(tree, context)) {
                throw new OgnlException("Arithmetic expressions cannot be used as parameter name");
            }
            Ognl.setValue((Object)tree, (Map)context, (Object)root, (Object)value);
            return null;
        });
    }

    private boolean isEvalExpression(Object tree, Map<String, Object> context) throws OgnlException {
        if (tree instanceof SimpleNode) {
            SimpleNode node = (SimpleNode)tree;
            OgnlContext ognlContext = null;
            if (context instanceof OgnlContext) {
                ognlContext = (OgnlContext)context;
            }
            return node.isEvalChain(ognlContext) || node.isSequence(ognlContext);
        }
        return false;
    }

    private boolean isArithmeticExpression(Object tree, Map<String, Object> context) throws OgnlException {
        if (tree instanceof SimpleNode) {
            SimpleNode node = (SimpleNode)tree;
            OgnlContext ognlContext = null;
            if (context instanceof OgnlContext) {
                ognlContext = (OgnlContext)context;
            }
            return node.isOperation(ognlContext);
        }
        return false;
    }

    private boolean isSimpleMethod(Object tree, Map<String, Object> context) throws OgnlException {
        if (tree instanceof SimpleNode) {
            SimpleNode node = (SimpleNode)tree;
            OgnlContext ognlContext = null;
            if (context instanceof OgnlContext) {
                ognlContext = (OgnlContext)context;
            }
            return node.isSimpleMethod(ognlContext) && !node.isChain(ognlContext);
        }
        return false;
    }

    public Object getValue(String name, Map<String, Object> context, Object root) throws OgnlException {
        return this.compileAndExecute(name, context, tree -> Ognl.getValue((Object)tree, (Map)context, (Object)root));
    }

    public Object callMethod(String name, Map<String, Object> context, Object root) throws OgnlException {
        return this.compileAndExecuteMethod(name, context, tree -> Ognl.getValue((Object)tree, (Map)context, (Object)root));
    }

    public Object getValue(String name, Map<String, Object> context, Object root, Class<?> resultType) throws OgnlException {
        return this.compileAndExecute(name, context, tree -> Ognl.getValue((Object)tree, (Map)context, (Object)root, (Class)resultType));
    }

    public Object compile(String expression) throws OgnlException {
        return this.compile(expression, null);
    }

    private <T> Object compileAndExecute(String expression, Map<String, Object> context, OgnlTask<T> task) throws OgnlException {
        Object tree;
        if (this.enableExpressionCache) {
            tree = this.expressionCache.get(expression);
            if (tree == null) {
                tree = Ognl.parseExpression((String)expression);
                this.checkEnableEvalExpression(tree, context);
                this.expressionCache.putIfAbsent(expression, tree);
            }
        } else {
            tree = Ognl.parseExpression((String)expression);
            this.checkEnableEvalExpression(tree, context);
        }
        return task.execute(tree);
    }

    private <T> Object compileAndExecuteMethod(String expression, Map<String, Object> context, OgnlTask<T> task) throws OgnlException {
        Object tree;
        if (this.enableExpressionCache) {
            tree = this.expressionCache.get(expression);
            if (tree == null) {
                tree = Ognl.parseExpression((String)expression);
                this.checkSimpleMethod(tree, context);
                this.expressionCache.putIfAbsent(expression, tree);
            }
        } else {
            tree = Ognl.parseExpression((String)expression);
            this.checkSimpleMethod(tree, context);
        }
        return task.execute(tree);
    }

    public Object compile(String expression, Map<String, Object> context) throws OgnlException {
        return this.compileAndExecute(expression, context, tree -> tree);
    }

    private void checkEnableEvalExpression(Object tree, Map<String, Object> context) throws OgnlException {
        if (!this.enableEvalExpression && this.isEvalExpression(tree, context)) {
            throw new OgnlException("Eval expressions/chained expressions have been disabled!");
        }
    }

    private void checkSimpleMethod(Object tree, Map<String, Object> context) throws OgnlException {
        if (!this.isSimpleMethod(tree, context)) {
            throw new OgnlException("It isn't a simple method which can be called!");
        }
    }

    public void copy(Object from, Object to, Map<String, Object> context, Collection<String> exclusions, Collection<String> inclusions) {
        this.copy(from, to, context, exclusions, inclusions, null);
    }

    public void copy(Object from, Object to, Map<String, Object> context, Collection<String> exclusions, Collection<String> inclusions, Class<?> editable) {
        PropertyDescriptor[] toPds;
        PropertyDescriptor[] fromPds;
        if (from == null || to == null) {
            LOG.warn("Attempting to copy from or to a null source. This is illegal and is bein skipped. This may be due to an error in an OGNL expression, action chaining, or some other event.");
            return;
        }
        Map<String, Object> contextFrom = this.createDefaultContext(from);
        Map<String, Object> contextTo = this.createDefaultContext(to);
        try {
            fromPds = this.getPropertyDescriptors(from);
            toPds = editable != null ? this.getPropertyDescriptors(editable) : this.getPropertyDescriptors(to);
        }
        catch (IntrospectionException e) {
            LOG.error("An error occurred", (Throwable)e);
            return;
        }
        HashMap<String, PropertyDescriptor> toPdHash = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor toPd : toPds) {
            toPdHash.put(toPd.getName(), toPd);
        }
        for (PropertyDescriptor fromPd : fromPds) {
            PropertyDescriptor toPd;
            if (fromPd.getReadMethod() == null) continue;
            boolean copy = true;
            if (exclusions != null && exclusions.contains(fromPd.getName())) {
                copy = false;
            } else if (inclusions != null && !inclusions.contains(fromPd.getName())) {
                copy = false;
            }
            if (!copy || (toPd = (PropertyDescriptor)toPdHash.get(fromPd.getName())) == null || toPd.getWriteMethod() == null) continue;
            try {
                this.compileAndExecute(fromPd.getName(), context, expr -> {
                    Object value = Ognl.getValue((Object)expr, (Map)contextFrom, (Object)from);
                    Ognl.setValue((Object)expr, (Map)contextTo, (Object)to, (Object)value);
                    return null;
                });
            }
            catch (OgnlException e) {
                LOG.debug("Got OGNL exception", (Throwable)e);
            }
        }
    }

    public void copy(Object from, Object to, Map<String, Object> context) {
        this.copy(from, to, context, null, null);
    }

    public PropertyDescriptor[] getPropertyDescriptors(Object source) throws IntrospectionException {
        BeanInfo beanInfo = this.getBeanInfo(source);
        return beanInfo.getPropertyDescriptors();
    }

    public PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) throws IntrospectionException {
        BeanInfo beanInfo = this.getBeanInfo(clazz);
        return beanInfo.getPropertyDescriptors();
    }

    public Map<String, Object> getBeanMap(Object source) throws IntrospectionException, OgnlException {
        PropertyDescriptor[] propertyDescriptors;
        HashMap<String, Object> beanMap = new HashMap<String, Object>();
        Map<String, Object> sourceMap = this.createDefaultContext(source);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = this.getPropertyDescriptors(source)) {
            String propertyName = propertyDescriptor.getDisplayName();
            Method readMethod = propertyDescriptor.getReadMethod();
            if (readMethod != null) {
                Object value = this.compileAndExecute(propertyName, null, expr -> Ognl.getValue((Object)expr, (Map)sourceMap, (Object)source));
                beanMap.put(propertyName, value);
                continue;
            }
            beanMap.put(propertyName, "There is no read method for " + propertyName);
        }
        return beanMap;
    }

    public BeanInfo getBeanInfo(Object from) throws IntrospectionException {
        return this.getBeanInfo(from.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanInfo getBeanInfo(Class<?> clazz) throws IntrospectionException {
        OgnlCache<Class<?>, BeanInfo> ognlCache = this.beanInfoCache;
        synchronized (ognlCache) {
            BeanInfo beanInfo = this.beanInfoCache.get(clazz);
            if (beanInfo == null) {
                beanInfo = Introspector.getBeanInfo(clazz, Object.class);
                this.beanInfoCache.putIfAbsent(clazz, beanInfo);
            }
            return beanInfo;
        }
    }

    void internalSetProperty(String name, Object value, Object o, Map<String, Object> context, boolean throwPropertyExceptions) throws ReflectionException {
        block4: {
            try {
                this.setValue(name, context, o, value);
            }
            catch (OgnlException e) {
                Throwable exception;
                Throwable reason = e.getReason();
                if (reason instanceof SecurityException) {
                    LOG.error("Could not evaluate this expression due to security constraints: [{}]", (Object)name, (Object)e);
                }
                String msg = "Caught OgnlException while setting property '" + name + "' on type '" + o.getClass().getName() + "'.";
                Throwable throwable = exception = reason == null ? e : reason;
                if (throwPropertyExceptions) {
                    throw new ReflectionException(msg, exception);
                }
                if (!this.devMode) break block4;
                LOG.warn(msg, exception);
            }
        }
    }

    protected Map<String, Object> createDefaultContext(Object root) {
        return this.createDefaultContext(root, null);
    }

    protected Map<String, Object> createDefaultContext(Object root, ClassResolver classResolver) {
        ClassResolver resolver = classResolver;
        if (resolver == null) {
            resolver = this.container.getInstance(CompoundRootAccessor.class);
        }
        SecurityMemberAccess memberAccess = new SecurityMemberAccess(this.allowStaticFieldAccess);
        memberAccess.setDisallowProxyMemberAccess(this.disallowProxyMemberAccess);
        if (this.devMode) {
            if (!this.warnReported.get()) {
                this.warnReported.set(true);
                LOG.warn("Working in devMode, using devMode excluded classes and packages!");
            }
            memberAccess.setExcludedClasses(this.devModeExcludedClasses);
            memberAccess.setExcludedPackageNamePatterns(this.devModeExcludedPackageNamePatterns);
            memberAccess.setExcludedPackageNames(this.devModeExcludedPackageNames);
        } else {
            memberAccess.setExcludedClasses(this.excludedClasses);
            memberAccess.setExcludedPackageNamePatterns(this.excludedPackageNamePatterns);
            memberAccess.setExcludedPackageNames(this.excludedPackageNames);
        }
        return Ognl.createDefaultContext((Object)root, (MemberAccess)memberAccess, (ClassResolver)resolver, (TypeConverter)this.defaultConverter);
    }

    private static interface OgnlTask<T> {
        public T execute(Object var1) throws OgnlException;
    }
}

