/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition;

import java.util.Locale;
import org.apache.tiles.BasicAttributeContext;
import org.apache.tiles.Definition;
import org.apache.tiles.definition.NoSuchDefinitionException;
import org.apache.tiles.definition.UnresolvingLocaleDefinitionsFactory;
import org.apache.tiles.request.Request;

public class LocaleDefinitionsFactory
extends UnresolvingLocaleDefinitionsFactory {
    @Override
    public Definition getDefinition(String name, Request tilesContext) {
        Definition retValue;
        Locale locale = null;
        if (tilesContext != null) {
            locale = this.localeResolver.resolveLocale(tilesContext);
        }
        if ((retValue = this.definitionDao.getDefinition(name, locale)) != null) {
            retValue = new Definition(retValue);
            String parentDefinitionName = retValue.getExtends();
            while (parentDefinitionName != null) {
                Definition parent = this.definitionDao.getDefinition(parentDefinitionName, locale);
                if (parent == null) {
                    throw new NoSuchDefinitionException("Cannot find definition '" + parentDefinitionName + "' ancestor of '" + retValue.getName() + "'");
                }
                retValue.inherit((BasicAttributeContext)parent);
                parentDefinitionName = parent.getExtends();
            }
        }
        return retValue;
    }
}

